theory ieee_float_Float64
  imports "NTP4Verif.NTP4Verif" real_Truncate ieee_float_RoundingMode
begin
typedecl  t
consts t'real :: "t \<Rightarrow> real"
consts t'isFinite :: "t \<Rightarrow> bool"
axiomatization where eb_gt_1:   "(1 :: int) < (11 :: int)"
axiomatization where sb_gt_1:   "(1 :: int) < (53 :: int)"
consts zeroF :: "t"
consts add :: "mode \<Rightarrow> t \<Rightarrow> t \<Rightarrow> t"
consts sub :: "mode \<Rightarrow> t \<Rightarrow> t \<Rightarrow> t"
consts mul :: "mode \<Rightarrow> t \<Rightarrow> t \<Rightarrow> t"
consts div :: "mode \<Rightarrow> t \<Rightarrow> t \<Rightarrow> t"
consts abs :: "t \<Rightarrow> t"
consts neg :: "t \<Rightarrow> t"
consts fma :: "mode \<Rightarrow> t \<Rightarrow> t \<Rightarrow> t \<Rightarrow> t"
consts sqrt :: "mode \<Rightarrow> t \<Rightarrow> t"
consts roundToIntegral :: "mode \<Rightarrow> t \<Rightarrow> t"
consts min :: "t \<Rightarrow> t \<Rightarrow> t"
consts max :: "t \<Rightarrow> t \<Rightarrow> t"
consts le :: "t \<Rightarrow> t \<Rightarrow> bool"
consts lt :: "t \<Rightarrow> t \<Rightarrow> bool"
consts eq :: "t \<Rightarrow> t \<Rightarrow> bool"
consts is_normal :: "t \<Rightarrow> bool"
consts is_subnormal :: "t \<Rightarrow> bool"
consts is_zero :: "t \<Rightarrow> bool"
consts is_infinite :: "t \<Rightarrow> bool"
consts is_nan :: "t \<Rightarrow> bool"
consts is_positive :: "t \<Rightarrow> bool"
consts is_negative :: "t \<Rightarrow> bool"
definition is_plus_infinity :: "t \<Rightarrow> _"
  where "is_plus_infinity x \<longleftrightarrow> is_infinite x \<and> is_positive x" for x
definition is_minus_infinity :: "t \<Rightarrow> _"
  where "is_minus_infinity x \<longleftrightarrow> is_infinite x \<and> is_negative x" for x
definition is_plus_zero :: "t \<Rightarrow> _"
  where "is_plus_zero x \<longleftrightarrow> is_zero x \<and> is_positive x" for x
definition is_minus_zero :: "t \<Rightarrow> _"
  where "is_minus_zero x \<longleftrightarrow> is_zero x \<and> is_negative x" for x
definition is_not_nan :: "t \<Rightarrow> _"
  where "is_not_nan x \<longleftrightarrow> t'isFinite x \<or> is_infinite x" for x
axiomatization where is_not_nan1:   "is_not_nan x \<longleftrightarrow> \<not>is_nan x"
  for x :: "t"
axiomatization where is_not_finite:   "\<not>t'isFinite x \<longleftrightarrow> is_infinite x \<or> is_nan x"
  for x :: "t"
axiomatization where zeroF_is_positive:   "is_positive zeroF"
axiomatization where zeroF_is_zero:   "is_zero zeroF"
axiomatization where zero_to_real:   "is_zero x \<longleftrightarrow> t'isFinite x \<and> t'real x = (0 :: Real.real)"
  for x :: "t"
consts of_int :: "mode \<Rightarrow> int \<Rightarrow> t"
consts to_int :: "mode \<Rightarrow> t \<Rightarrow> int"
axiomatization where zero_of_int:   "zeroF = of_int m (0 :: int)"
  for m :: "mode"
consts round :: "mode \<Rightarrow> real \<Rightarrow> real"
axiomatization where max_int_spec:   "(179769313486231570814527423731704356798070567525844996598917476803157260780028538760589558632766878171540458953514382464234321326889464182768467546703537516986049910576551282076245490090389328944075868508455133942304583236903222948165808559332123348274797826204144723168738177180919299881250404026184124858368 :: int) = power2 (power2 ((11 :: int) - (1 :: int))) - power2 (power2 ((11 :: int) - (1 :: int)) - (53 :: int))"
axiomatization where max_real_int:   "(179769313486231570814527423731704356798070567525844996598917476803157260780028538760589558632766878171540458953514382464234321326889464182768467546703537516986049910576551282076245490090389328944075868508455133942304583236903222948165808559332123348274797826204144723168738177180919299881250404026184124858368 :: Real.real) = real_of_int (179769313486231570814527423731704356798070567525844996598917476803157260780028538760589558632766878171540458953514382464234321326889464182768467546703537516986049910576551282076245490090389328944075868508455133942304583236903222948165808559332123348274797826204144723168738177180919299881250404026184124858368 :: int)"
definition in_range :: "real \<Rightarrow> _"
  where "in_range x \<longleftrightarrow> -(179769313486231570814527423731704356798070567525844996598917476803157260780028538760589558632766878171540458953514382464234321326889464182768467546703537516986049910576551282076245490090389328944075868508455133942304583236903222948165808559332123348274797826204144723168738177180919299881250404026184124858368 :: Real.real) \<le> x \<and> x \<le> (179769313486231570814527423731704356798070567525844996598917476803157260780028538760589558632766878171540458953514382464234321326889464182768467546703537516986049910576551282076245490090389328944075868508455133942304583236903222948165808559332123348274797826204144723168738177180919299881250404026184124858368 :: Real.real)" for x
definition in_int_range :: "int \<Rightarrow> _"
  where "in_int_range i \<longleftrightarrow> -(179769313486231570814527423731704356798070567525844996598917476803157260780028538760589558632766878171540458953514382464234321326889464182768467546703537516986049910576551282076245490090389328944075868508455133942304583236903222948165808559332123348274797826204144723168738177180919299881250404026184124858368 :: int) \<le> i \<and> i \<le> (179769313486231570814527423731704356798070567525844996598917476803157260780028538760589558632766878171540458953514382464234321326889464182768467546703537516986049910576551282076245490090389328944075868508455133942304583236903222948165808559332123348274797826204144723168738177180919299881250404026184124858368 :: int)" for i
axiomatization where is_finite:   "in_range (t'real x)"
 if "t'isFinite x"
  for x :: "t"
definition no_overflow :: "mode \<Rightarrow> real \<Rightarrow> _"
  where "no_overflow m x \<longleftrightarrow> in_range (round m x)" for m x
axiomatization where Bounded_real_no_overflow:   "no_overflow m x"
 if "in_range x"
  for x :: "real"
  and m :: "mode"
axiomatization where Round_monotonic:   "round m x \<le> round m y"
 if "x \<le> y"
  for x :: "real"
  and y :: "real"
  and m :: "mode"
axiomatization where Round_idempotent:   "round m1 (round m2 x) = round m2 x"
  for m1 :: "mode"
  and m2 :: "mode"
  and x :: "real"
axiomatization where Round_to_real:   "round m (t'real x) = t'real x"
 if "t'isFinite x"
  for x :: "t"
  and m :: "mode"
axiomatization where Round_down_le:   "round RTN x \<le> x"
  for x :: "real"
axiomatization where Round_up_ge:   "x \<le> round RTP x"
  for x :: "real"
axiomatization where Round_down_neg:   "round RTN (-x) = -round RTP x"
  for x :: "real"
axiomatization where Round_up_neg:   "round RTP (-x) = -round RTN x"
  for x :: "real"
axiomatization where pow2sb1:   "(9007199254740992 :: int) = power2 (53 :: int)"
definition in_safe_int_range :: "int \<Rightarrow> _"
  where "in_safe_int_range i \<longleftrightarrow> -(9007199254740992 :: int) \<le> i \<and> i \<le> (9007199254740992 :: int)" for i
axiomatization where Exact_rounding_for_integers:   "round m (real_of_int i) = real_of_int i"
 if "in_safe_int_range i"
  for i :: "int"
  and m :: "mode"
consts from_real :: "mode \<Rightarrow> real \<Rightarrow> t"
axiomatization where from_real_in_range:   "t'isFinite (from_real m r) \<and> t'real (from_real m r) = round m r"
 if "in_range (round m r)"
  for m :: "mode"
  and r :: "real"
axiomatization where from_real_large_neg:   "is_infinite (from_real m r) \<and> is_negative (from_real m r)"
 if "round m r < -(179769313486231570814527423731704356798070567525844996598917476803157260780028538760589558632766878171540458953514382464234321326889464182768467546703537516986049910576551282076245490090389328944075868508455133942304583236903222948165808559332123348274797826204144723168738177180919299881250404026184124858368 :: Real.real)"
  for m :: "mode"
  and r :: "real"
axiomatization where from_real_large_pos:   "is_infinite (from_real m r) \<and> is_positive (from_real m r)"
 if "(179769313486231570814527423731704356798070567525844996598917476803157260780028538760589558632766878171540458953514382464234321326889464182768467546703537516986049910576551282076245490090389328944075868508455133942304583236903222948165808559332123348274797826204144723168738177180919299881250404026184124858368 :: Real.real) < round m r"
  for m :: "mode"
  and r :: "real"
definition same_sign :: "t \<Rightarrow> t \<Rightarrow> _"
  where "same_sign x y \<longleftrightarrow> is_positive x \<and> is_positive y \<or> is_negative x \<and> is_negative y" for x y
definition diff_sign :: "t \<Rightarrow> t \<Rightarrow> _"
  where "diff_sign x y \<longleftrightarrow> is_positive x \<and> is_negative y \<or> is_negative x \<and> is_positive y" for x y
axiomatization where feq_eq:   "x = y"
 if "t'isFinite x"
 and "t'isFinite y"
 and "\<not>is_zero x"
 and "eq x y"
  for x :: "t"
  and y :: "t"
axiomatization where eq_feq:   "eq x y"
 if "t'isFinite x"
 and "t'isFinite y"
 and "x = y"
  for x :: "t"
  and y :: "t"
axiomatization where eq_refl:   "eq x x"
 if "t'isFinite x"
  for x :: "t"
axiomatization where eq_sym:   "eq y x"
 if "eq x y"
  for x :: "t"
  and y :: "t"
axiomatization where eq_trans:   "eq x z"
 if "eq x y"
 and "eq y z"
  for x :: "t"
  and y :: "t"
  and z :: "t"
axiomatization where eq_zero:   "eq zeroF (neg zeroF)"
axiomatization where eq_to_real_finite:   "eq x y \<longleftrightarrow> t'real x = t'real y"
 if "t'isFinite x"
 and "t'isFinite y"
  for x :: "t"
  and y :: "t"
axiomatization where eq_special'0:   "is_not_nan x"
 if "eq x y"
  for x :: "t"
  and y :: "t"
axiomatization where eq_special'1:   "is_not_nan y"
 if "eq x y"
  for x :: "t"
  and y :: "t"
axiomatization where eq_special'2:   "t'isFinite x \<and> t'isFinite y \<or> is_infinite x \<and> is_infinite y \<and> same_sign x y"
 if "eq x y"
  for x :: "t"
  and y :: "t"
axiomatization where lt_finite:   "lt x y \<longleftrightarrow> t'real x < t'real y"
 if "t'isFinite x"
 and "t'isFinite y"
  for x :: "t"
  and y :: "t"
axiomatization where le_finite:   "le x y \<longleftrightarrow> t'real x \<le> t'real y"
 if "t'isFinite x"
 and "t'isFinite y"
  for x :: "t"
  and y :: "t"
axiomatization where le_lt_trans:   "lt x z"
 if "le x y"
 and "lt y z"
  for x :: "t"
  and y :: "t"
  and z :: "t"
axiomatization where lt_le_trans:   "lt x z"
 if "lt x y"
 and "le y z"
  for x :: "t"
  and y :: "t"
  and z :: "t"
axiomatization where le_ge_asym:   "eq x y"
 if "le x y"
 and "le y x"
  for x :: "t"
  and y :: "t"
axiomatization where not_lt_ge:   "le y x"
 if "\<not>lt x y"
 and "is_not_nan x"
 and "is_not_nan y"
  for x :: "t"
  and y :: "t"
axiomatization where not_gt_le:   "le x y"
 if "\<not>lt y x"
 and "is_not_nan x"
 and "is_not_nan y"
  for y :: "t"
  and x :: "t"
axiomatization where le_special:   "t'isFinite x \<and> t'isFinite y \<or> is_minus_infinity x \<and> is_not_nan y \<or> is_not_nan x \<and> is_plus_infinity y"
 if "le x y"
  for x :: "t"
  and y :: "t"
axiomatization where lt_special:   "t'isFinite x \<and> t'isFinite y \<or> is_minus_infinity x \<and> is_not_nan y \<and> \<not>is_minus_infinity y \<or> is_not_nan x \<and> \<not>is_plus_infinity x \<and> is_plus_infinity y"
 if "lt x y"
  for x :: "t"
  and y :: "t"
axiomatization where lt_lt_finite:   "t'isFinite y"
 if "lt x y"
 and "lt y z"
  for x :: "t"
  and y :: "t"
  and z :: "t"
axiomatization where positive_to_real:   "(0 :: Real.real) \<le> t'real x"
 if "t'isFinite x"
 and "is_positive x"
  for x :: "t"
axiomatization where to_real_positive:   "is_positive x"
 if "t'isFinite x"
 and "(0 :: Real.real) < t'real x"
  for x :: "t"
axiomatization where negative_to_real:   "t'real x \<le> (0 :: Real.real)"
 if "t'isFinite x"
 and "is_negative x"
  for x :: "t"
axiomatization where to_real_negative:   "is_negative x"
 if "t'isFinite x"
 and "t'real x < (0 :: Real.real)"
  for x :: "t"
axiomatization where negative_xor_positive:   "\<not>(is_positive x \<and> is_negative x)"
  for x :: "t"
axiomatization where negative_or_positive:   "is_positive x \<or> is_negative x"
 if "is_not_nan x"
  for x :: "t"
axiomatization where diff_sign_trans:   "same_sign x z"
 if "diff_sign x y"
 and "diff_sign y z"
  for x :: "t"
  and y :: "t"
  and z :: "t"
axiomatization where diff_sign_product:   "diff_sign x y"
 if "t'isFinite x"
 and "t'isFinite y"
 and "t'real x * t'real y < (0 :: Real.real)"
  for x :: "t"
  and y :: "t"
axiomatization where same_sign_product:   "(0 :: Real.real) \<le> t'real x * t'real y"
 if "t'isFinite x"
 and "t'isFinite y"
 and "same_sign x y"
  for x :: "t"
  and y :: "t"
definition product_sign :: "t \<Rightarrow> t \<Rightarrow> t \<Rightarrow> _"
  where "product_sign z x y \<longleftrightarrow> (same_sign x y \<longrightarrow> is_positive z) \<and> (diff_sign x y \<longrightarrow> is_negative z)" for z x y
definition overflow_value :: "mode \<Rightarrow> t \<Rightarrow> _"
  where "overflow_value m x \<longleftrightarrow> (case m of RTN \<Rightarrow> (if is_positive x then t'isFinite x \<and> t'real x = (179769313486231570814527423731704356798070567525844996598917476803157260780028538760589558632766878171540458953514382464234321326889464182768467546703537516986049910576551282076245490090389328944075868508455133942304583236903222948165808559332123348274797826204144723168738177180919299881250404026184124858368 :: Real.real) else is_infinite x) | RTP \<Rightarrow> (if is_positive x then is_infinite x else t'isFinite x \<and> t'real x = -(179769313486231570814527423731704356798070567525844996598917476803157260780028538760589558632766878171540458953514382464234321326889464182768467546703537516986049910576551282076245490090389328944075868508455133942304583236903222948165808559332123348274797826204144723168738177180919299881250404026184124858368 :: Real.real)) | RTZ \<Rightarrow> (if is_positive x then t'isFinite x \<and> t'real x = (179769313486231570814527423731704356798070567525844996598917476803157260780028538760589558632766878171540458953514382464234321326889464182768467546703537516986049910576551282076245490090389328944075868508455133942304583236903222948165808559332123348274797826204144723168738177180919299881250404026184124858368 :: Real.real) else t'isFinite x \<and> t'real x = -(179769313486231570814527423731704356798070567525844996598917476803157260780028538760589558632766878171540458953514382464234321326889464182768467546703537516986049910576551282076245490090389328944075868508455133942304583236903222948165808559332123348274797826204144723168738177180919299881250404026184124858368 :: Real.real)) | RNA \<Rightarrow> is_infinite x | RNE \<Rightarrow> is_infinite x)" for m x
definition sign_zero_result :: "mode \<Rightarrow> t \<Rightarrow> _"
  where "sign_zero_result m x \<longleftrightarrow> is_zero x \<longrightarrow> (case m of RTN \<Rightarrow> is_negative x | _ \<Rightarrow> is_positive x)" for m x
axiomatization where add_finite'0:   "t'isFinite (add m x y)"
 if "t'isFinite x"
 and "t'isFinite y"
 and "no_overflow m (t'real x + t'real y)"
  for x :: "t"
  and y :: "t"
  and m :: "mode"
axiomatization where add_finite'1:   "t'real (add m x y) = round m (t'real x + t'real y)"
 if "t'isFinite x"
 and "t'isFinite y"
 and "no_overflow m (t'real x + t'real y)"
  for x :: "t"
  and y :: "t"
  and m :: "mode"
axiomatization where add_finite_rev'0:   "t'isFinite x"
 if "t'isFinite (add m x y)"
  for m :: "mode"
  and x :: "t"
  and y :: "t"
axiomatization where add_finite_rev'1:   "t'isFinite y"
 if "t'isFinite (add m x y)"
  for m :: "mode"
  and x :: "t"
  and y :: "t"
axiomatization where add_finite_rev_n'0:   "no_overflow m (t'real x + t'real y)"
 if "to_nearest m"
 and "t'isFinite (add m x y)"
  for m :: "mode"
  and x :: "t"
  and y :: "t"
axiomatization where add_finite_rev_n'1:   "t'real (add m x y) = round m (t'real x + t'real y)"
 if "to_nearest m"
 and "t'isFinite (add m x y)"
  for m :: "mode"
  and x :: "t"
  and y :: "t"
axiomatization where sub_finite'0:   "t'isFinite (sub m x y)"
 if "t'isFinite x"
 and "t'isFinite y"
 and "no_overflow m (t'real x - t'real y)"
  for x :: "t"
  and y :: "t"
  and m :: "mode"
axiomatization where sub_finite'1:   "t'real (sub m x y) = round m (t'real x - t'real y)"
 if "t'isFinite x"
 and "t'isFinite y"
 and "no_overflow m (t'real x - t'real y)"
  for x :: "t"
  and y :: "t"
  and m :: "mode"
axiomatization where sub_finite_rev'0:   "t'isFinite x"
 if "t'isFinite (sub m x y)"
  for m :: "mode"
  and x :: "t"
  and y :: "t"
axiomatization where sub_finite_rev'1:   "t'isFinite y"
 if "t'isFinite (sub m x y)"
  for m :: "mode"
  and x :: "t"
  and y :: "t"
axiomatization where sub_finite_rev_n'0:   "no_overflow m (t'real x - t'real y)"
 if "to_nearest m"
 and "t'isFinite (sub m x y)"
  for m :: "mode"
  and x :: "t"
  and y :: "t"
axiomatization where sub_finite_rev_n'1:   "t'real (sub m x y) = round m (t'real x - t'real y)"
 if "to_nearest m"
 and "t'isFinite (sub m x y)"
  for m :: "mode"
  and x :: "t"
  and y :: "t"
axiomatization where mul_finite'0:   "t'isFinite (mul m x y)"
 if "t'isFinite x"
 and "t'isFinite y"
 and "no_overflow m (t'real x * t'real y)"
  for x :: "t"
  and y :: "t"
  and m :: "mode"
axiomatization where mul_finite'1:   "t'real (mul m x y) = round m (t'real x * t'real y)"
 if "t'isFinite x"
 and "t'isFinite y"
 and "no_overflow m (t'real x * t'real y)"
  for x :: "t"
  and y :: "t"
  and m :: "mode"
axiomatization where mul_finite_rev'0:   "t'isFinite x"
 if "t'isFinite (mul m x y)"
  for m :: "mode"
  and x :: "t"
  and y :: "t"
axiomatization where mul_finite_rev'1:   "t'isFinite y"
 if "t'isFinite (mul m x y)"
  for m :: "mode"
  and x :: "t"
  and y :: "t"
axiomatization where mul_finite_rev_n'0:   "no_overflow m (t'real x * t'real y)"
 if "to_nearest m"
 and "t'isFinite (mul m x y)"
  for m :: "mode"
  and x :: "t"
  and y :: "t"
axiomatization where mul_finite_rev_n'1:   "t'real (mul m x y) = round m (t'real x * t'real y)"
 if "to_nearest m"
 and "t'isFinite (mul m x y)"
  for m :: "mode"
  and x :: "t"
  and y :: "t"
axiomatization where div_finite'0:   "t'isFinite (ieee_float_Float64.div m x y)"
 if "t'isFinite x"
 and "t'isFinite y"
 and "\<not>is_zero y"
 and "no_overflow m (t'real x / t'real y)"
  for x :: "t"
  and y :: "t"
  and m :: "mode"
axiomatization where div_finite'1:   "t'real (ieee_float_Float64.div m x y) = round m (t'real x / t'real y)"
 if "t'isFinite x"
 and "t'isFinite y"
 and "\<not>is_zero y"
 and "no_overflow m (t'real x / t'real y)"
  for x :: "t"
  and y :: "t"
  and m :: "mode"
axiomatization where div_finite_rev:   "t'isFinite x \<and> t'isFinite y \<and> \<not>is_zero y \<or> t'isFinite x \<and> is_infinite y \<and> t'real (ieee_float_Float64.div m x y) = (0 :: Real.real)"
 if "t'isFinite (ieee_float_Float64.div m x y)"
  for m :: "mode"
  and x :: "t"
  and y :: "t"
axiomatization where div_finite_rev_n'0:   "no_overflow m (t'real x / t'real y)"
 if "to_nearest m"
 and "t'isFinite (ieee_float_Float64.div m x y)"
 and "t'isFinite y"
  for m :: "mode"
  and x :: "t"
  and y :: "t"
axiomatization where div_finite_rev_n'1:   "t'real (ieee_float_Float64.div m x y) = round m (t'real x / t'real y)"
 if "to_nearest m"
 and "t'isFinite (ieee_float_Float64.div m x y)"
 and "t'isFinite y"
  for m :: "mode"
  and x :: "t"
  and y :: "t"
axiomatization where neg_finite'0:   "t'isFinite (neg x)"
 if "t'isFinite x"
  for x :: "t"
axiomatization where neg_finite'1:   "t'real (neg x) = -t'real x"
 if "t'isFinite x"
  for x :: "t"
axiomatization where neg_finite_rev'0:   "t'isFinite x"
 if "t'isFinite (neg x)"
  for x :: "t"
axiomatization where neg_finite_rev'1:   "t'real (neg x) = -t'real x"
 if "t'isFinite (neg x)"
  for x :: "t"
axiomatization where abs_finite'0:   "t'isFinite (abs x)"
 if "t'isFinite x"
  for x :: "t"
axiomatization where abs_finite'1:   "t'real (abs x) = Groups.abs (t'real x)"
 if "t'isFinite x"
  for x :: "t"
axiomatization where abs_finite'2:   "is_positive (abs x)"
 if "t'isFinite x"
  for x :: "t"
axiomatization where abs_finite_rev'0:   "t'isFinite x"
 if "t'isFinite (abs x)"
  for x :: "t"
axiomatization where abs_finite_rev'1:   "t'real (abs x) = Groups.abs (t'real x)"
 if "t'isFinite (abs x)"
  for x :: "t"
axiomatization where abs_universal:   "\<not>is_negative (abs x)"
  for x :: "t"
axiomatization where fma_finite'0:   "t'isFinite (fma m x y z)"
 if "t'isFinite x"
 and "t'isFinite y"
 and "t'isFinite z"
 and "no_overflow m (t'real x * t'real y + t'real z)"
  for x :: "t"
  and y :: "t"
  and z :: "t"
  and m :: "mode"
axiomatization where fma_finite'1:   "t'real (fma m x y z) = round m (t'real x * t'real y + t'real z)"
 if "t'isFinite x"
 and "t'isFinite y"
 and "t'isFinite z"
 and "no_overflow m (t'real x * t'real y + t'real z)"
  for x :: "t"
  and y :: "t"
  and z :: "t"
  and m :: "mode"
axiomatization where fma_finite_rev'0:   "t'isFinite x"
 if "t'isFinite (fma m x y z)"
  for m :: "mode"
  and x :: "t"
  and y :: "t"
  and z :: "t"
axiomatization where fma_finite_rev'1:   "t'isFinite y"
 if "t'isFinite (fma m x y z)"
  for m :: "mode"
  and x :: "t"
  and y :: "t"
  and z :: "t"
axiomatization where fma_finite_rev'2:   "t'isFinite z"
 if "t'isFinite (fma m x y z)"
  for m :: "mode"
  and x :: "t"
  and y :: "t"
  and z :: "t"
axiomatization where fma_finite_rev_n'0:   "no_overflow m (t'real x * t'real y + t'real z)"
 if "to_nearest m"
 and "t'isFinite (fma m x y z)"
  for m :: "mode"
  and x :: "t"
  and y :: "t"
  and z :: "t"
axiomatization where fma_finite_rev_n'1:   "t'real (fma m x y z) = round m (t'real x * t'real y + t'real z)"
 if "to_nearest m"
 and "t'isFinite (fma m x y z)"
  for m :: "mode"
  and x :: "t"
  and y :: "t"
  and z :: "t"
axiomatization where sqrt_finite'0:   "t'isFinite (sqrt m x)"
 if "t'isFinite x"
 and "(0 :: Real.real) \<le> t'real x"
  for x :: "t"
  and m :: "mode"
axiomatization where sqrt_finite'1:   "t'real (sqrt m x) = round m (NthRoot.sqrt (t'real x))"
 if "t'isFinite x"
 and "(0 :: Real.real) \<le> t'real x"
  for x :: "t"
  and m :: "mode"
axiomatization where sqrt_finite_rev'0:   "t'isFinite x"
 if "t'isFinite (sqrt m x)"
  for m :: "mode"
  and x :: "t"
axiomatization where sqrt_finite_rev'1:   "(0 :: Real.real) \<le> t'real x"
 if "t'isFinite (sqrt m x)"
  for m :: "mode"
  and x :: "t"
axiomatization where sqrt_finite_rev'2:   "t'real (sqrt m x) = round m (NthRoot.sqrt (t'real x))"
 if "t'isFinite (sqrt m x)"
  for m :: "mode"
  and x :: "t"
definition same_sign_real :: "t \<Rightarrow> real \<Rightarrow> _"
  where "same_sign_real x r \<longleftrightarrow> is_positive x \<and> (0 :: Real.real) < r \<or> is_negative x \<and> r < (0 :: Real.real)" for x r
axiomatization where add_special:   "(is_nan x \<or> is_nan y \<longrightarrow> is_nan (add m x y)) \<and> (t'isFinite x \<and> is_infinite y \<longrightarrow> is_infinite (add m x y) \<and> same_sign (add m x y) y) \<and> (is_infinite x \<and> t'isFinite y \<longrightarrow> is_infinite (add m x y) \<and> same_sign (add m x y) x) \<and> (is_infinite x \<and> is_infinite y \<and> same_sign x y \<longrightarrow> is_infinite (add m x y) \<and> same_sign (add m x y) x) \<and> (is_infinite x \<and> is_infinite y \<and> diff_sign x y \<longrightarrow> is_nan (add m x y)) \<and> (t'isFinite x \<and> t'isFinite y \<and> \<not>no_overflow m (t'real x + t'real y) \<longrightarrow> same_sign_real (add m x y) (t'real x + t'real y) \<and> overflow_value m (add m x y)) \<and> (t'isFinite x \<and> t'isFinite y \<longrightarrow> (if same_sign x y then same_sign (add m x y) x else sign_zero_result m (add m x y)))"
  for m :: "mode"
  and x :: "t"
  and y :: "t"
axiomatization where sub_special:   "(is_nan x \<or> is_nan y \<longrightarrow> is_nan (sub m x y)) \<and> (t'isFinite x \<and> is_infinite y \<longrightarrow> is_infinite (sub m x y) \<and> diff_sign (sub m x y) y) \<and> (is_infinite x \<and> t'isFinite y \<longrightarrow> is_infinite (sub m x y) \<and> same_sign (sub m x y) x) \<and> (is_infinite x \<and> is_infinite y \<and> same_sign x y \<longrightarrow> is_nan (sub m x y)) \<and> (is_infinite x \<and> is_infinite y \<and> diff_sign x y \<longrightarrow> is_infinite (sub m x y) \<and> same_sign (sub m x y) x) \<and> (t'isFinite x \<and> t'isFinite y \<and> \<not>no_overflow m (t'real x - t'real y) \<longrightarrow> same_sign_real (sub m x y) (t'real x - t'real y) \<and> overflow_value m (sub m x y)) \<and> (t'isFinite x \<and> t'isFinite y \<longrightarrow> (if diff_sign x y then same_sign (sub m x y) x else sign_zero_result m (sub m x y)))"
  for m :: "mode"
  and x :: "t"
  and y :: "t"
axiomatization where mul_special:   "(is_nan x \<or> is_nan y \<longrightarrow> is_nan (mul m x y)) \<and> (is_zero x \<and> is_infinite y \<longrightarrow> is_nan (mul m x y)) \<and> (t'isFinite x \<and> is_infinite y \<and> \<not>is_zero x \<longrightarrow> is_infinite (mul m x y)) \<and> (is_infinite x \<and> is_zero y \<longrightarrow> is_nan (mul m x y)) \<and> (is_infinite x \<and> t'isFinite y \<and> \<not>is_zero y \<longrightarrow> is_infinite (mul m x y)) \<and> (is_infinite x \<and> is_infinite y \<longrightarrow> is_infinite (mul m x y)) \<and> (t'isFinite x \<and> t'isFinite y \<and> \<not>no_overflow m (t'real x * t'real y) \<longrightarrow> overflow_value m (mul m x y)) \<and> (\<not>is_nan (mul m x y) \<longrightarrow> product_sign (mul m x y) x y)"
  for m :: "mode"
  and x :: "t"
  and y :: "t"
axiomatization where div_special:   "(is_nan x \<or> is_nan y \<longrightarrow> is_nan (ieee_float_Float64.div m x y)) \<and> (t'isFinite x \<and> is_infinite y \<longrightarrow> is_zero (ieee_float_Float64.div m x y)) \<and> (is_infinite x \<and> t'isFinite y \<longrightarrow> is_infinite (ieee_float_Float64.div m x y)) \<and> (is_infinite x \<and> is_infinite y \<longrightarrow> is_nan (ieee_float_Float64.div m x y)) \<and> (t'isFinite x \<and> t'isFinite y \<and> \<not>is_zero y \<and> \<not>no_overflow m (t'real x / t'real y) \<longrightarrow> overflow_value m (ieee_float_Float64.div m x y)) \<and> (t'isFinite x \<and> is_zero y \<and> \<not>is_zero x \<longrightarrow> is_infinite (ieee_float_Float64.div m x y)) \<and> (is_zero x \<and> is_zero y \<longrightarrow> is_nan (ieee_float_Float64.div m x y)) \<and> (\<not>is_nan (ieee_float_Float64.div m x y) \<longrightarrow> product_sign (ieee_float_Float64.div m x y) x y)"
  for m :: "mode"
  and x :: "t"
  and y :: "t"
axiomatization where neg_special'0:   "is_nan x \<longrightarrow> is_nan (neg x)"
  for x :: "t"
axiomatization where neg_special'1:   "is_infinite x \<longrightarrow> is_infinite (neg x)"
  for x :: "t"
axiomatization where neg_special'2:   "\<not>is_nan x \<longrightarrow> diff_sign x (neg x)"
  for x :: "t"
axiomatization where abs_special'0:   "is_nan x \<longrightarrow> is_nan (abs x)"
  for x :: "t"
axiomatization where abs_special'1:   "is_infinite x \<longrightarrow> is_infinite (abs x)"
  for x :: "t"
axiomatization where abs_special'2:   "\<not>is_nan x \<longrightarrow> is_positive (abs x)"
  for x :: "t"
axiomatization where fma_special:   "(is_nan x \<or> is_nan y \<or> is_nan z \<longrightarrow> is_nan (fma m x y z)) \<and> (is_zero x \<and> is_infinite y \<longrightarrow> is_nan (fma m x y z)) \<and> (is_infinite x \<and> is_zero y \<longrightarrow> is_nan (fma m x y z)) \<and> (t'isFinite x \<and> \<not>is_zero x \<and> is_infinite y \<and> t'isFinite z \<longrightarrow> is_infinite (fma m x y z) \<and> product_sign (fma m x y z) x y) \<and> (t'isFinite x \<and> \<not>is_zero x \<and> is_infinite y \<and> is_infinite z \<longrightarrow> (if product_sign z x y then is_infinite (fma m x y z) \<and> same_sign (fma m x y z) z else is_nan (fma m x y z))) \<and> (is_infinite x \<and> t'isFinite y \<and> \<not>is_zero y \<and> t'isFinite z \<longrightarrow> is_infinite (fma m x y z) \<and> product_sign (fma m x y z) x y) \<and> (is_infinite x \<and> t'isFinite y \<and> \<not>is_zero y \<and> is_infinite z \<longrightarrow> (if product_sign z x y then is_infinite (fma m x y z) \<and> same_sign (fma m x y z) z else is_nan (fma m x y z))) \<and> (is_infinite x \<and> is_infinite y \<and> t'isFinite z \<longrightarrow> is_infinite (fma m x y z) \<and> product_sign (fma m x y z) x y) \<and> (t'isFinite x \<and> t'isFinite y \<and> is_infinite z \<longrightarrow> is_infinite (fma m x y z) \<and> same_sign (fma m x y z) z) \<and> (is_infinite x \<and> is_infinite y \<and> is_infinite z \<longrightarrow> (if product_sign z x y then is_infinite (fma m x y z) \<and> same_sign (fma m x y z) z else is_nan (fma m x y z))) \<and> (t'isFinite x \<and> t'isFinite y \<and> t'isFinite z \<and> \<not>no_overflow m (t'real x * t'real y + t'real z) \<longrightarrow> same_sign_real (fma m x y z) (t'real x * t'real y + t'real z) \<and> overflow_value m (fma m x y z)) \<and> (t'isFinite x \<and> t'isFinite y \<and> t'isFinite z \<longrightarrow> (if product_sign z x y then same_sign (fma m x y z) z else t'real x * t'real y + t'real z = (0 :: Real.real) \<longrightarrow> (if m = RTN then is_negative (fma m x y z) else is_positive (fma m x y z))))"
  for m :: "mode"
  and x :: "t"
  and y :: "t"
  and z :: "t"
axiomatization where sqrt_special:   "(is_nan x \<longrightarrow> is_nan (sqrt m x)) \<and> (is_plus_infinity x \<longrightarrow> is_plus_infinity (sqrt m x)) \<and> (is_minus_infinity x \<longrightarrow> is_nan (sqrt m x)) \<and> (t'isFinite x \<and> t'real x < (0 :: Real.real) \<longrightarrow> is_nan (sqrt m x)) \<and> (is_zero x \<longrightarrow> same_sign (sqrt m x) x) \<and> (t'isFinite x \<and> (0 :: Real.real) < t'real x \<longrightarrow> is_positive (sqrt m x))"
  for m :: "mode"
  and x :: "t"
axiomatization where of_int_add_exact:   "eq (of_int m (i + j)) (add n (of_int m i) (of_int m j))"
 if "in_safe_int_range i"
 and "in_safe_int_range j"
 and "in_safe_int_range (i + j)"
  for i :: "int"
  and j :: "int"
  and m :: "mode"
  and n :: "mode"
axiomatization where of_int_sub_exact:   "eq (of_int m (i - j)) (sub n (of_int m i) (of_int m j))"
 if "in_safe_int_range i"
 and "in_safe_int_range j"
 and "in_safe_int_range (i - j)"
  for i :: "int"
  and j :: "int"
  and m :: "mode"
  and n :: "mode"
axiomatization where of_int_mul_exact:   "eq (of_int m (i * j)) (mul n (of_int m i) (of_int m j))"
 if "in_safe_int_range i"
 and "in_safe_int_range j"
 and "in_safe_int_range (i * j)"
  for i :: "int"
  and j :: "int"
  and m :: "mode"
  and n :: "mode"
axiomatization where Min_r:   "eq (min x y) y"
 if "le y x"
  for y :: "t"
  and x :: "t"
axiomatization where Min_l:   "eq (min x y) x"
 if "le x y"
  for x :: "t"
  and y :: "t"
axiomatization where Max_r:   "eq (max x y) x"
 if "le y x"
  for y :: "t"
  and x :: "t"
axiomatization where Max_l:   "eq (max x y) y"
 if "le x y"
  for x :: "t"
  and y :: "t"
consts is_int :: "t \<Rightarrow> bool"
axiomatization where zeroF_is_int:   "is_int zeroF"
axiomatization where of_int_is_int:   "is_int (of_int m x)"
 if "in_int_range x"
  for x :: "int"
  and m :: "mode"
axiomatization where big_float_is_int:   "is_int i"
 if "t'isFinite i"
 and "le i (neg (of_int m (9007199254740992 :: int))) \<or> le (of_int m (9007199254740992 :: int)) i"
  for i :: "t"
  and m :: "mode"
axiomatization where roundToIntegral_is_int:   "is_int (roundToIntegral m x)"
 if "t'isFinite x"
  for x :: "t"
  and m :: "mode"
axiomatization where eq_is_int:   "is_int y"
 if "eq x y"
 and "is_int x"
  for x :: "t"
  and y :: "t"
axiomatization where add_int:   "is_int (add m x y)"
 if "is_int x"
 and "is_int y"
 and "t'isFinite (add m x y)"
  for x :: "t"
  and y :: "t"
  and m :: "mode"
axiomatization where sub_int:   "is_int (sub m x y)"
 if "is_int x"
 and "is_int y"
 and "t'isFinite (sub m x y)"
  for x :: "t"
  and y :: "t"
  and m :: "mode"
axiomatization where mul_int:   "is_int (mul m x y)"
 if "is_int x"
 and "is_int y"
 and "t'isFinite (mul m x y)"
  for x :: "t"
  and y :: "t"
  and m :: "mode"
axiomatization where fma_int:   "is_int (fma m x y z)"
 if "is_int x"
 and "is_int y"
 and "is_int z"
 and "t'isFinite (fma m x y z)"
  for x :: "t"
  and y :: "t"
  and z :: "t"
  and m :: "mode"
axiomatization where neg_int:   "is_int (neg x)"
 if "is_int x"
  for x :: "t"
axiomatization where abs_int:   "is_int (abs x)"
 if "is_int x"
  for x :: "t"
axiomatization where is_int_of_int:   "eq x (of_int m' (to_int m x))"
 if "is_int x"
  for x :: "t"
  and m' :: "mode"
  and m :: "mode"
axiomatization where is_int_to_int:   "in_int_range (to_int m x)"
 if "is_int x"
  for x :: "t"
  and m :: "mode"
axiomatization where is_int_is_finite:   "t'isFinite x"
 if "is_int x"
  for x :: "t"
axiomatization where int_to_real:   "t'real x = real_of_int (to_int m x)"
 if "is_int x"
  for x :: "t"
  and m :: "mode"
axiomatization where truncate_int:   "eq (roundToIntegral m i) i"
 if "is_int i"
  for i :: "t"
  and m :: "mode"
axiomatization where truncate_neg:   "roundToIntegral RTZ x = roundToIntegral RTP x"
 if "t'isFinite x"
 and "is_negative x"
  for x :: "t"
axiomatization where truncate_pos:   "roundToIntegral RTZ x = roundToIntegral RTN x"
 if "t'isFinite x"
 and "is_positive x"
  for x :: "t"
axiomatization where ceil_le:   "le x (roundToIntegral RTP x)"
 if "t'isFinite x"
  for x :: "t"
axiomatization where ceil_lest:   "le (roundToIntegral RTP x) y"
 if "le x y"
 and "is_int y"
  for x :: "t"
  and y :: "t"
axiomatization where ceil_to_real:   "t'real (roundToIntegral RTP x) = real_of_int (ceil (t'real x))"
 if "t'isFinite x"
  for x :: "t"
axiomatization where ceil_to_int:   "to_int m (roundToIntegral RTP x) = ceil (t'real x)"
 if "t'isFinite x"
  for x :: "t"
  and m :: "mode"
axiomatization where floor_le:   "le (roundToIntegral RTN x) x"
 if "t'isFinite x"
  for x :: "t"
axiomatization where floor_lest:   "le y (roundToIntegral RTN x)"
 if "le y x"
 and "is_int y"
  for y :: "t"
  and x :: "t"
axiomatization where floor_to_real:   "t'real (roundToIntegral RTN x) = real_of_int (real_Truncate.floor (t'real x))"
 if "t'isFinite x"
  for x :: "t"
axiomatization where floor_to_int:   "to_int m (roundToIntegral RTN x) = real_Truncate.floor (t'real x)"
 if "t'isFinite x"
  for x :: "t"
  and m :: "mode"
axiomatization where RNA_down:   "roundToIntegral RNA x = roundToIntegral RTN x"
 if "lt (sub RNE x (roundToIntegral RTN x)) (sub RNE (roundToIntegral RTP x) x)"
  for x :: "t"
axiomatization where RNA_up:   "roundToIntegral RNA x = roundToIntegral RTP x"
 if "lt (sub RNE (roundToIntegral RTP x) x) (sub RNE x (roundToIntegral RTN x))"
  for x :: "t"
axiomatization where RNA_down_tie:   "roundToIntegral RNA x = roundToIntegral RTN x"
 if "eq (sub RNE x (roundToIntegral RTN x)) (sub RNE (roundToIntegral RTP x) x)"
 and "is_negative x"
  for x :: "t"
axiomatization where RNA_up_tie:   "roundToIntegral RNA x = roundToIntegral RTP x"
 if "eq (sub RNE (roundToIntegral RTP x) x) (sub RNE x (roundToIntegral RTN x))"
 and "is_positive x"
  for x :: "t"
axiomatization where to_int_roundToIntegral:   "to_int m x = to_int m (roundToIntegral m x)"
  for m :: "mode"
  and x :: "t"
axiomatization where to_int_monotonic:   "to_int m x \<le> to_int m y"
 if "t'isFinite x"
 and "t'isFinite y"
 and "le x y"
  for x :: "t"
  and y :: "t"
  and m :: "mode"
axiomatization where to_int_of_int:   "to_int m (of_int m i) = i"
 if "in_safe_int_range i"
  for i :: "int"
  and m :: "mode"
axiomatization where eq_to_int:   "to_int m x = to_int m y"
 if "t'isFinite x"
 and "eq x y"
  for x :: "t"
  and y :: "t"
  and m :: "mode"
axiomatization where neg_to_int:   "to_int m (neg x) = -to_int m x"
 if "is_int x"
  for x :: "t"
  and m :: "mode"
axiomatization where roundToIntegral_is_finite:   "t'isFinite (roundToIntegral m x)"
 if "t'isFinite x"
  for x :: "t"
  and m :: "mode"
axiomatization where round_bound_ne'0:   "x - (1 :: Real.real) / (9007199254740992) * Groups.abs x - (1 :: Real.real) / (404804506614621236704990693437834614099113299528284236713802716054860679135990693783920767402874248990374155728633623822779617474771586953734026799881477019843034848553132722728933815484186432682479535356945490137124014966849385397236206711298319112681620113024717539104666829230461005064372655017292012526615415482186989568) \<le> round RNE x"
 if "no_overflow RNE x"
  for x :: "real"
axiomatization where round_bound_ne'1:   "round RNE x \<le> x + (1 :: Real.real) / (9007199254740992) * Groups.abs x + (1 :: Real.real) / (404804506614621236704990693437834614099113299528284236713802716054860679135990693783920767402874248990374155728633623822779617474771586953734026799881477019843034848553132722728933815484186432682479535356945490137124014966849385397236206711298319112681620113024717539104666829230461005064372655017292012526615415482186989568)"
 if "no_overflow RNE x"
  for x :: "real"
axiomatization where round_bound'0:   "x - (1 :: Real.real) / (4503599627370496) * Groups.abs x - (1 :: Real.real) / (202402253307310618352495346718917307049556649764142118356901358027430339567995346891960383701437124495187077864316811911389808737385793476867013399940738509921517424276566361364466907742093216341239767678472745068562007483424692698618103355649159556340810056512358769552333414615230502532186327508646006263307707741093494784) \<le> round m x"
 if "no_overflow m x"
  for m :: "mode"
  and x :: "real"
axiomatization where round_bound'1:   "round m x \<le> x + (1 :: Real.real) / (4503599627370496) * Groups.abs x + (1 :: Real.real) / (202402253307310618352495346718917307049556649764142118356901358027430339567995346891960383701437124495187077864316811911389808737385793476867013399940738509921517424276566361364466907742093216341239767678472745068562007483424692698618103355649159556340810056512358769552333414615230502532186327508646006263307707741093494784)"
 if "no_overflow m x"
  for m :: "mode"
  and x :: "real"
end
