theory int_NumOf
  imports "NTP4Verif.NTP4Verif"
begin
consts numof :: "(int \<Rightarrow> bool) \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int"
axiomatization where numof'def:   "if b \<le> a then numof p a b = (0 :: int) else if p (b - (1 :: int)) = True then numof p a b = (1 :: int) + numof p a (b - (1 :: int)) else numof p a b = numof p a (b - (1 :: int))"
  for b :: "int"
  and a :: "int"
  and p :: "int \<Rightarrow> bool"
axiomatization where Numof_bounds'0:   "(0 :: int) \<le> numof p a b"
 if "a < b"
  for a :: "int"
  and b :: "int"
  and p :: "int \<Rightarrow> bool"
axiomatization where Numof_bounds'1:   "numof p a b \<le> b - a"
 if "a < b"
  for a :: "int"
  and b :: "int"
  and p :: "int \<Rightarrow> bool"
axiomatization where Numof_append:   "numof p a c = numof p a b + numof p b c"
 if "a \<le> b"
 and "b \<le> c"
  for a :: "int"
  and b :: "int"
  and c :: "int"
  and p :: "int \<Rightarrow> bool"
axiomatization where Numof_left_no_add:   "numof p a b = numof p (a + (1 :: int)) b"
 if "a < b"
 and "\<not>p a = True"
  for a :: "int"
  and b :: "int"
  and p :: "int \<Rightarrow> bool"
axiomatization where Numof_left_add:   "numof p a b = (1 :: int) + numof p (a + (1 :: int)) b"
 if "a < b"
 and "p a = True"
  for a :: "int"
  and b :: "int"
  and p :: "int \<Rightarrow> bool"
axiomatization where Empty:   "numof p a b = (0 :: int)"
 if "\<forall>(n :: int). a \<le> n \<and> n < b \<longrightarrow> \<not>p n = True"
  for a :: "int"
  and b :: "int"
  and p :: "int \<Rightarrow> bool"
axiomatization where Full:   "numof p a b = b - a"
 if "a \<le> b"
 and "\<forall>(n :: int). a \<le> n \<and> n < b \<longrightarrow> p n = True"
  for a :: "int"
  and b :: "int"
  and p :: "int \<Rightarrow> bool"
axiomatization where numof_increasing:   "numof p i j \<le> numof p i k"
 if "i \<le> j"
 and "j \<le> k"
  for i :: "int"
  and j :: "int"
  and k :: "int"
  and p :: "int \<Rightarrow> bool"
axiomatization where numof_strictly_increasing:   "numof p i j < numof p i l"
 if "i \<le> j"
 and "j \<le> k"
 and "k < l"
 and "p k = True"
  for i :: "int"
  and j :: "int"
  and k :: "int"
  and l :: "int"
  and p :: "int \<Rightarrow> bool"
axiomatization where numof_change_any:   "numof p1 a b \<le> numof p2 a b"
 if "\<forall>(j :: int). a \<le> j \<and> j < b \<longrightarrow> p1 j = True \<longrightarrow> p2 j = True"
  for a :: "int"
  and b :: "int"
  and p1 :: "int \<Rightarrow> bool"
  and p2 :: "int \<Rightarrow> bool"
axiomatization where numof_change_some:   "numof p1 a b < numof p2 a b"
 if "a \<le> i"
 and "i < b"
 and "\<forall>(j :: int). a \<le> j \<and> j < b \<longrightarrow> p1 j = True \<longrightarrow> p2 j = True"
 and "\<not>p1 i = True"
 and "p2 i = True"
  for a :: "int"
  and i :: "int"
  and b :: "int"
  and p1 :: "int \<Rightarrow> bool"
  and p2 :: "int \<Rightarrow> bool"
axiomatization where numof_change_equiv:   "numof p2 a b = numof p1 a b"
 if "\<forall>(j :: int). a \<le> j \<and> j < b \<longrightarrow> p1 j = True \<longleftrightarrow> p2 j = True"
  for a :: "int"
  and b :: "int"
  and p1 :: "int \<Rightarrow> bool"
  and p2 :: "int \<Rightarrow> bool"
end
