theory int_Sum
  imports "NTP4Verif.NTP4Verif"
begin
consts sum :: "(int \<Rightarrow> int) \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int"
axiomatization where sum'def:   "if b \<le> a then sum f a b = (0 :: int) else sum f a b = sum f a (b - (1 :: int)) + f (b - (1 :: int))"
  for b :: "int"
  and a :: "int"
  and f :: "int \<Rightarrow> int"
axiomatization where sum_left:   "sum f a b = f a + sum f (a + (1 :: int)) b"
 if "a < b"
  for a :: "int"
  and b :: "int"
  and f :: "int \<Rightarrow> int"
axiomatization where sum_ext:   "sum f a b = sum g a b"
 if "\<forall>(i :: int). a \<le> i \<and> i < b \<longrightarrow> f i = g i"
  for a :: "int"
  and b :: "int"
  and f :: "int \<Rightarrow> int"
  and g :: "int \<Rightarrow> int"
axiomatization where sum_le:   "sum f a b \<le> sum g a b"
 if "\<forall>(i :: int). a \<le> i \<and> i < b \<longrightarrow> f i \<le> g i"
  for a :: "int"
  and b :: "int"
  and f :: "int \<Rightarrow> int"
  and g :: "int \<Rightarrow> int"
axiomatization where sum_zero:   "sum f a b = (0 :: int)"
 if "\<forall>(i :: int). a \<le> i \<and> i < b \<longrightarrow> f i = (0 :: int)"
  for a :: "int"
  and b :: "int"
  and f :: "int \<Rightarrow> int"
axiomatization where sum_nonneg:   "(0 :: int) \<le> sum f a b"
 if "\<forall>(i :: int). a \<le> i \<and> i < b \<longrightarrow> (0 :: int) \<le> f i"
  for a :: "int"
  and b :: "int"
  and f :: "int \<Rightarrow> int"
axiomatization where sum_decomp:   "sum f a c = sum f a b + sum f b c"
 if "a \<le> b"
 and "b \<le> c"
  for a :: "int"
  and b :: "int"
  and c :: "int"
  and f :: "int \<Rightarrow> int"
axiomatization where shift_left:   "sum f a b = sum g c d"
 if "b - a = d - c"
 and "\<forall>(i :: int). a \<le> i \<and> i < b \<longrightarrow> f i = g (c + i - a)"
  for b :: "int"
  and a :: "int"
  and d :: "int"
  and c :: "int"
  and f :: "int \<Rightarrow> int"
  and g :: "int \<Rightarrow> int"
end
