theory ufloat_USingle
  imports "NTP4Verif.NTP4Verif" ieee_float_RoundingMode
begin
typedecl  usingle
definition eps :: "real"
  where "eps = (1 :: Real.real) / (16777216) / ((1 :: Real.real) + (1 :: Real.real) / (16777216))"
definition eta :: "real"
  where "eta = (1 :: Real.real) / (1427247692705959881058285969449495136382746624)"
consts uround :: "mode \<Rightarrow> real \<Rightarrow> usingle"
consts to_real :: "usingle \<Rightarrow> real"
consts of_int :: "int \<Rightarrow> usingle"
axiomatization where to_real_of_int:   "to_real (of_int x) = real_of_int x"
  for x :: "int"
consts uzero :: "usingle"
axiomatization where uzero_spec:   "to_real uzero = (0 :: Real.real)"
consts uone :: "usingle"
axiomatization where uone_spec:   "to_real uone = (1 :: Real.real)"
consts utwo :: "usingle"
axiomatization where utwo_spec:   "to_real utwo = (2 :: Real.real)"
axiomatization where eps_bounds'0:   "(0 :: Real.real) < eps"
axiomatization where eps_bounds'1:   "eps < (1 :: Real.real)"
axiomatization where eta_bounds'0:   "(0 :: Real.real) < eta"
axiomatization where eta_bounds'1:   "eta < (1 :: Real.real)"
definition uadd :: "usingle \<Rightarrow> usingle \<Rightarrow> usingle"
  where "uadd x y = uround RNE (to_real x + to_real y)" for x y
axiomatization where uadd'spec'1:   "abs (to_real (uadd x y) - (to_real x + to_real y)) \<le> abs (to_real x)"
  for x :: "usingle"
  and y :: "usingle"
axiomatization where uadd'spec'0:   "abs (to_real (uadd x y) - (to_real x + to_real y)) \<le> abs (to_real y)"
  for x :: "usingle"
  and y :: "usingle"
axiomatization where uadd'spec:   "abs (to_real (uadd x y) - (to_real x + to_real y)) \<le> abs (to_real x + to_real y) * eps"
  for x :: "usingle"
  and y :: "usingle"
definition usub :: "usingle \<Rightarrow> usingle \<Rightarrow> usingle"
  where "usub x y = uround RNE (to_real x - to_real y)" for x y
axiomatization where usub'spec'1:   "abs (to_real (usub x y) - (to_real x - to_real y)) \<le> abs (to_real x)"
  for x :: "usingle"
  and y :: "usingle"
axiomatization where usub'spec'0:   "abs (to_real (usub x y) - (to_real x - to_real y)) \<le> abs (to_real y)"
  for x :: "usingle"
  and y :: "usingle"
axiomatization where usub'spec:   "abs (to_real (usub x y) - (to_real x - to_real y)) \<le> abs (to_real x - to_real y) * eps"
  for x :: "usingle"
  and y :: "usingle"
definition umul :: "usingle \<Rightarrow> usingle \<Rightarrow> usingle"
  where "umul x y = uround RNE (to_real x * to_real y)" for x y
axiomatization where umul'spec:   "abs (to_real (umul x y) - to_real x * to_real y) \<le> abs (to_real x * to_real y) * eps + eta"
  for x :: "usingle"
  and y :: "usingle"
consts udiv :: "usingle \<Rightarrow> usingle \<Rightarrow> usingle"
axiomatization where udiv'def:   "udiv x y = uround RNE (to_real x / to_real y)"
 if "\<not>to_real y = (0 :: Real.real)"
  for y :: "usingle"
  and x :: "usingle"
axiomatization where udiv'spec:   "abs (to_real (udiv x y) - to_real x / to_real y) \<le> abs (to_real x / to_real y) * eps + eta"
 if "\<not>to_real y = (0 :: Real.real)"
  for y :: "usingle"
  and x :: "usingle"
definition uminus :: "usingle \<Rightarrow> usingle"
  where "uminus x = uround RNE (-to_real x)" for x
axiomatization where uminus'spec:   "to_real (uminus x) = -to_real x"
  for x :: "usingle"
consts is_exact :: "(usingle \<Rightarrow> usingle \<Rightarrow> usingle) \<Rightarrow> usingle \<Rightarrow> usingle \<Rightarrow> bool"
consts udiv_exact :: "usingle \<Rightarrow> usingle \<Rightarrow> usingle"
consts udiv_closure :: "usingle \<Rightarrow> usingle \<Rightarrow> usingle"
axiomatization where udiv_closure_def:   "udiv_closure y y1 = udiv y y1"
  for y :: "usingle"
  and y1 :: "usingle"
axiomatization where udiv_exact'def:   "udiv_exact x y = uround RNE (to_real x / to_real y)"
 if "\<not>to_real y = (0 :: Real.real)"
 and "is_exact udiv_closure x y"
  for y :: "usingle"
  and x :: "usingle"
axiomatization where udiv_exact'spec:   "abs (to_real (udiv_exact x y) - to_real x / to_real y) \<le> eta"
 if "\<not>to_real y = (0 :: Real.real)"
 and "is_exact udiv_closure x y"
  for y :: "usingle"
  and x :: "usingle"
consts infix_slsldot :: "usingle \<Rightarrow> usingle \<Rightarrow> usingle"
axiomatization where infix_slsldot'def:   "infix_slsldot x y = udiv x y"
 if "\<not>to_real y = (0 :: Real.real)"
  for y :: "usingle"
  and x :: "usingle"
consts infix_slslsldot :: "usingle \<Rightarrow> usingle \<Rightarrow> usingle"
axiomatization where infix_slslsldot'def:   "infix_slslsldot x y = udiv_exact x y"
 if "\<not>to_real y = (0 :: Real.real)"
 and "is_exact udiv_closure x y"
  for y :: "usingle"
  and x :: "usingle"
consts u0 :: "usingle"
axiomatization where to_real_u0:   "to_real u0 = (0 :: Real.real)"
consts u1 :: "usingle"
axiomatization where to_real_u1:   "to_real u1 = (1 :: Real.real)"
consts u2 :: "usingle"
axiomatization where to_real_u2:   "to_real u2 = (2 :: Real.real)"
consts u4 :: "usingle"
axiomatization where to_real_u4:   "to_real u4 = (4 :: Real.real)"
consts u8 :: "usingle"
axiomatization where to_real_u8:   "to_real u8 = (8 :: Real.real)"
consts u16 :: "usingle"
axiomatization where to_real_u16:   "to_real u16 = (16 :: Real.real)"
consts u32 :: "usingle"
axiomatization where to_real_u32:   "to_real u32 = (32 :: Real.real)"
consts u64 :: "usingle"
axiomatization where to_real_u64:   "to_real u64 = (64 :: Real.real)"
consts u128 :: "usingle"
axiomatization where to_real_u128:   "to_real u128 = (128 :: Real.real)"
consts u256 :: "usingle"
axiomatization where to_real_u256:   "to_real u256 = (256 :: Real.real)"
consts u512 :: "usingle"
axiomatization where to_real_u512:   "to_real u512 = (512 :: Real.real)"
consts u1024 :: "usingle"
axiomatization where to_real_u1024:   "to_real u1024 = (1024 :: Real.real)"
consts u2048 :: "usingle"
axiomatization where to_real_u2048:   "to_real u2048 = (2048 :: Real.real)"
consts u4096 :: "usingle"
axiomatization where to_real_u4096:   "to_real u4096 = (4096 :: Real.real)"
consts u8192 :: "usingle"
axiomatization where to_real_u8192:   "to_real u8192 = (8192 :: Real.real)"
consts u16384 :: "usingle"
axiomatization where to_real_u16384:   "to_real u16384 = (16384 :: Real.real)"
consts u32768 :: "usingle"
axiomatization where to_real_u32768:   "to_real u32768 = (32768 :: Real.real)"
consts u65536 :: "usingle"
axiomatization where to_real_u65536:   "to_real u65536 = (65536 :: Real.real)"
definition is_positive_power_of_2 :: "usingle \<Rightarrow> _"
  where "is_positive_power_of_2 x \<longleftrightarrow> x = u1 \<or> x = u2 \<or> x = u4 \<or> x = u8 \<or> x = u16 \<or> x = u32 \<or> x = u64 \<or> x = u128 \<or> x = u256 \<or> x = u4096 \<or> x = u8192 \<or> x = u16384 \<or> x = u32768 \<or> x = u65536" for x
axiomatization where div_by_positive_power_of_2_is_exact:   "is_exact udiv_closure x y"
 if "is_positive_power_of_2 y"
  for y :: "usingle"
  and x :: "usingle"
end
