theory c_String
  imports "NTP4Verif.NTP4Verif" "Why3STD.Ref_Ref" c_C int_Unsigned
begin
consts zero_char :: "char"
axiomatization where zero_char'def:   "of_char zero_char = (0 :: int)"
axiomatization where numcodes:   "of_char (''0123456789'' ! nat i) = of_char (''0'' ! (0 :: nat)) + i"
 if "(0 :: int) \<le> i"
 and "i < (10 :: int)"
  for i :: "int"
axiomatization where lowcodes:   "of_char (''abcdefghijklmnopqrstuvwxyz'' ! nat i) = of_char (''a'' ! (0 :: nat)) + i"
 if "(0 :: int) \<le> i"
 and "i < (26 :: int)"
  for i :: "int"
axiomatization where upcodes:   "of_char (''ABCDEFGHIJKLMNOPQRSTUVWXYZ'' ! nat i) = of_char (''A'' ! (0 :: nat)) + i"
 if "(0 :: int) \<le> i"
 and "i < (26 :: int)"
  for i :: "int"
axiomatization where code_0:   "of_char (''0'' ! (0 :: nat)) = (48 :: int)"
axiomatization where code_a:   "of_char (''a'' ! (0 :: nat)) = (97 :: int)"
axiomatization where code_A:   "of_char (''A'' ! (0 :: nat)) = (65 :: int)"
axiomatization where code_minus:   "of_char (''-'' ! (0 :: nat)) = (45 :: int)"
consts strlen :: "(int \<Rightarrow> char) \<Rightarrow> int \<Rightarrow> int"
axiomatization where strlen_def:   "strlen s ofs = i"
 if "(0 :: int) \<le> i"
 and "\<forall>(j :: int). (0 :: int) \<le> j \<and> j < i \<longrightarrow> \<not>of_char (s (ofs + j)) = (0 :: int)"
 and "of_char (s (ofs + i)) = (0 :: int)"
  for i :: "int"
  and s :: "int \<Rightarrow> char"
  and ofs :: "int"
axiomatization where strlen_invalid:   "strlen s ofs < (0 :: int)"
 if "\<forall>(i :: int). (0 :: int) \<le> i \<longrightarrow> \<not>of_char (s (ofs + i)) = (0 :: int)"
  for s :: "int \<Rightarrow> char"
  and ofs :: "int"
definition valid_string :: "char ptr \<Rightarrow> _"
  where "valid_string p \<longleftrightarrow> (0 :: int) \<le> strlen (pelts p) (offset p) \<and> valid p ((1 :: int) + strlen (pelts p) (offset p))" for p
end
