theory matrix_Matrix63
  imports "NTP4Verif.NTP4Verif"
begin
typedecl 'a matrix
consts elts :: "'a matrix \<Rightarrow> int \<Rightarrow> int \<Rightarrow> 'a"
consts rows :: "'a matrix \<Rightarrow> 63 word"
consts columns :: "'a matrix \<Rightarrow> 63 word"
axiomatization where matrix'invariant'0:   "(0 :: int) \<le> sint (rows self)"
  for self :: "'a matrix"
axiomatization where matrix'invariant'1:   "(0 :: int) \<le> sint (columns self)"
  for self :: "'a matrix"
consts get_unsafe :: "'a matrix \<Rightarrow> int \<Rightarrow> int \<Rightarrow> 'a"
axiomatization where get_unsafe'spec:   "get_unsafe a r c = elts a r c"
  for a :: "'a matrix"
  and r :: "int"
  and c :: "int"
consts set_unsafe :: "'a matrix \<Rightarrow> int \<Rightarrow> int \<Rightarrow> 'a \<Rightarrow> 'a matrix"
axiomatization where set_unsafe'spec'0:   "rows (set_unsafe a r c v) = rows a"
  for a :: "'a matrix"
  and r :: "int"
  and c :: "int"
  and v :: "'a"
axiomatization where set_unsafe'spec'1:   "columns (set_unsafe a r c v) = columns a"
  for a :: "'a matrix"
  and r :: "int"
  and c :: "int"
  and v :: "'a"
axiomatization where set_unsafe'spec'2:   "elts (set_unsafe a r c v) = (elts a)(r := (elts a r)(c := v))"
  for a :: "'a matrix"
  and r :: "int"
  and c :: "int"
  and v :: "'a"
definition valid_index :: "'a matrix \<Rightarrow> 63 word \<Rightarrow> 63 word \<Rightarrow> _"
  where "valid_index a r c \<longleftrightarrow> ((0 :: int) \<le> sint r \<and> sint r < sint (rows a)) \<and> (0 :: int) \<le> sint c \<and> sint c < sint (columns a)" for a r c
end
