From Stdlib Require Import Strings.String.
From Stdlib Require Import String Ascii.
From Stdlib Require Arith.
From stdpp Require Import base.
From stdpp Require Import fin_maps.
From stdpp Require Import gmap.
From stdpp Require Import base gmultiset.
From Stdlib Require Classical.
From Stdlib Require Import ZArith.
From stdpp.bitvector Require Import definitions tactics.
From Stdlib Require Import Sorting.Sorted.
From Stdlib Require Import Reals.Rbasic_fun.
From Stdlib Require Import Reals.Abstract.ConstructiveAbs.
From Stdlib Require Import Reals.Rdefinitions.
From stdpp Require Import list_relations.
From stdpp Require Import list_numbers.
From stdpp Require Import functions.
From Stdlib Require Import ClassicalEpsilon.
From stdpp Require Import base decidable.
From Stdlib Require Import ZArith.Zeuclid.
From Stdlib Require Import ZArith.Znumtheory.
From stdpp Require Import propset.
From Stdlib Require Import Reals.
Require Import Why3.Base.
Open Scope Z_scope.
Definition is_bool (x : Z) := x = 0%Z ∨ x = 1%Z.
Axiom is_uint8 : Z -> Prop.
Axiom is_uint8_def : forall  (x : Z), is_uint8 x = (0%Z ≤ x ∧ x < 256%Z).
Axiom is_sint8 : Z -> Prop.
Axiom is_sint8_def : forall  (x : Z), is_sint8 x = (- 128%Z ≤ x ∧ x < 128%Z).
Axiom is_uint16 : Z -> Prop.
Axiom is_uint16_def : forall  (x : Z), is_uint16 x = (0%Z ≤ x ∧ x < 65536%Z).
Definition is_sint16 (x : Z) := - 32768%Z ≤ x ∧ x < 32768%Z.
Axiom is_uint32 : Z -> Prop.
Axiom is_uint32_def : forall  (x : Z), is_uint32 x = (0%Z ≤ x ∧ x < 4294967296%Z).
Axiom is_sint32 : Z -> Prop.
Axiom is_sint32_def : forall  (x : Z), is_sint32 x = (- 2147483648%Z ≤ x ∧ x < 2147483648%Z).
Axiom is_uint64 : Z -> Prop.
Axiom is_uint64_def : forall  (x : Z), is_uint64 x = (0%Z ≤ x ∧ x < 18446744073709551616%Z).
Axiom is_sint64 : Z -> Prop.
Axiom is_sint64_def : forall  (x : Z), is_sint64 x = (- 9223372036854775808%Z ≤ x ∧ x < 9223372036854775808%Z).
Axiom is_bool0 : is_bool 0%Z.
Axiom is_bool1 : is_bool 1%Z.
Definition to_bool (x : Z) : Z := if decide (x = 0%Z) then 0%Z else 1%Z.
Axiom to_uint8 : Z -> Z.
Axiom to_sint8 : Z -> Z.
Axiom to_uint16 : Z -> Z.
Axiom to_sint16 : Z -> Z.
Axiom to_uint32 : Z -> Z.
Axiom to_sint32 : Z -> Z.
Axiom to_uint64 : Z -> Z.
Axiom to_sint64 : Z -> Z.
Axiom two_power_abs : Z -> Z.
Definition is_uint (n : Z) (x : Z) := 0%Z ≤ x ∧ x < two_power_abs n.
Definition is_sint (n : Z) (x : Z) := - two_power_abs n ≤ x ∧ x < two_power_abs n.
Axiom to_uint : Z -> Z -> Z.
Axiom to_sint : Z -> Z -> Z.
Axiom is_to_uint8 : forall  (x : Z), is_uint8 (to_uint8 x).
Axiom is_to_sint8 : forall  (x : Z), is_sint8 (to_sint8 x).
Axiom is_to_uint16 : forall  (x : Z), is_uint16 (to_uint16 x).
Axiom is_to_sint16 : forall  (x : Z), is_sint16 (to_sint16 x).
Axiom is_to_uint32 : forall  (x : Z), is_uint32 (to_uint32 x).
Axiom is_to_sint32 : forall  (x : Z), is_sint32 (to_sint32 x).
Axiom is_to_uint64 : forall  (x : Z), is_uint64 (to_uint64 x).
Axiom is_to_sint64 : forall  (x : Z), is_sint64 (to_sint64 x).
Axiom id_uint8 : forall  (x : Z) (fact0 : 0%Z ≤ x) (fact1 : x < 256%Z), to_uint8 x = x.
Axiom id_sint8 : forall  (x : Z) (fact0 : - 128%Z ≤ x) (fact1 : x < 128%Z), to_sint8 x = x.
Axiom id_uint16 : forall  (x : Z) (fact0 : 0%Z ≤ x) (fact1 : x < 65536%Z), to_uint16 x = x.
Axiom id_sint16 : forall  (x : Z) (fact0 : - 32768%Z ≤ x) (fact1 : x < 32768%Z), to_sint16 x = x.
Axiom id_uint32 : forall  (x : Z) (fact0 : 0%Z ≤ x) (fact1 : x < 4294967296%Z), to_uint32 x = x.
Axiom id_sint32 : forall  (x : Z) (fact0 : - 2147483648%Z ≤ x) (fact1 : x < 2147483648%Z), to_sint32 x = x.
Axiom id_uint64 : forall  (x : Z) (fact0 : 0%Z ≤ x) (fact1 : x < 18446744073709551616%Z), to_uint64 x = x.
Axiom id_sint64 : forall  (x : Z) (fact0 : - 9223372036854775808%Z ≤ x) (fact1 : x < 9223372036854775808%Z), to_sint64 x = x.
Axiom proj_int8 : forall  (x : Z), to_sint8 (to_uint8 x) = to_sint8 x.
Axiom proj_int16 : forall  (x : Z), to_sint16 (to_uint16 x) = to_sint16 x.
Axiom proj_int32 : forall  (x : Z), to_sint32 (to_uint32 x) = to_sint32 x.
Axiom proj_int64 : forall  (x : Z), to_sint64 (to_uint64 x) = to_sint64 x.
Axiom lnot : Z -> Z.
Axiom land : Z -> Z -> Z.
Axiom lxor : Z -> Z -> Z.
Axiom lor : Z -> Z -> Z.
Axiom lsl : Z -> Z -> Z.
Axiom lsr : Z -> Z -> Z.
Axiom bit_testb : Z -> Z -> bool.
Axiom bit_test : Z -> Z -> Prop.
