#!/bin/env python3

import sys
import os

GOALS = []
with open('test_set.manifest', 'r') as f:
    for line in f:
        line = line.strip()
        if not line:
            continue
        if line.startswith('#'):
            continue
        if ',' in line:
            line = line.split(',')[0]
        if ':' not in line:
            print(line)
            sys.exit(1)
        file, vc = line.split(':')
        file = file.replace('.mlw', '_vcg')
        GOALS.append((file, vc))

def mk_list(lang, suffix):
    with open(f'test_set.{lang}.lst', 'w') as f:
        for file, vc in GOALS:
            path = os.path.join(file, lang, vc + suffix)
            f.write(path + '\n')

mk_list('isabelle', '.thy')
mk_list('rocq', '.v')
mk_list('lean', '.lean')