#!/usr/bin/env python3
import os
import sys

if len(sys.argv) < 2:
    print("The path to the csv manifest file is required")
    sys.exit(1)

path = sys.argv[1]
mlws = {}

with open(path, 'r') as f:
    for line in f:
        file, goal, status = line.split(',')
        if file not in mlws:
            mlws[file] = []
        mlws[file].append(goal)

for file, goals in mlws.items():
    # Replace .mlw extension with _vcg
    if file.endswith('.mlw'):
        vcg_file = file[:-4] + '_vcg'
    else:
        raise ValueError(f"{file} is not a .mlw file")
    for goal in goals:
        thy_file = os.path.join(vcg_file, 'lean', goal + '.lean')
        if not os.path.exists(thy_file):
            print(f"\033[91m{thy_file} is missing\033[0m")
            # List all .thy files under the isabelle directory

    vcg_dir = os.path.join(vcg_file, 'lean')
    if os.path.exists(vcg_dir):
        for f in os.listdir(vcg_dir):
            if f.endswith('.lean'):
                name = os.path.splitext(f)[0]
                if name not in goals:
                    print(f"\033[38;5;208m{file}:{name} is not in the manifest\033[0m")
    else:
        print(f"Directory {vcg_dir} does not exist")

