#!/bin/env python3
import xml.etree.ElementTree as ET 
import os
import glob

def check_status(dir):
    with open(os.path.join(dir, "why3session.xml"), "r") as f:
        xml = ET.parse(f)
        def test(e):
            if 'proved' in e.attrib:
                return e.attrib['proved'] == 'true'
            for x in e:
                if not ('proved' in x.attrib and x.attrib['proved'] == 'true'):
                    #print(f"{dir}: {x.attrib['name']}")
                    return False
            return True
        return all(test(e) for e in xml.iter(tag='theory'))


if __name__ == "__main__":
    base_path = os.path.expanduser("~/repo/why3-1.8.0/examples")
    
    if not os.path.exists(base_path):
        print(f"Base path does not exist: {base_path}")
    
    why3session_dirs = []
    
    # Walk through all directories recursively
    for root, dirs, files in os.walk(base_path):
        # Check if why3session.xml exists in current directory
        if "why3session.xml" in files and os.path.exists(os.path.join(root + '.mlw')):
            why3session_dirs.append(root)
    
    print(len(why3session_dirs))
    
    for dir in why3session_dirs:
        if not check_status(dir):
            relative_path = os.path.relpath(dir, base_path)
            if os.path.exists(os.path.join('data/why3/common', relative_path + '.mlw')) or \
               os.path.exists(os.path.join('data/why3/no-lemma5', relative_path + '.mlw')):
                print(f"{dir} is not verified")

