#!/bin/env python3

import sys
import os

visited = set()
targets = []

with open('test_set.manifest', 'r') as f:
    for line in f:
        line = line.strip()
        if not line:
            continue
        if line.startswith('#'):
            continue
        file, _ = line.split(':')
        if file not in visited:
            visited.add(file)
            file = file.replace('.mlw', '_vcg/isabelle')
            file = os.path.realpath(file)
            targets.append(file)

for target in targets:
    print(target)