#!/bin/env python3
import os
import sys
import csv

if len(sys.argv) < 2:
    print("Usage: ./difficulty_of.py <path>")
    sys.exit(1)

path = sys.argv[1]
if os.path.isfile(path):
    target_dir = os.path.dirname(path)
else:
    target_dir = path

master_dir = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))
target_dir = os.path.relpath(target_dir, master_dir)
target_path = os.path.relpath(path, master_dir)
print(target_path)

INFO = {}

dir = os.path.abspath(target_dir)
while dir != master_dir:
    test_path = os.path.join(dir, "why3_auto_level_3.db.csv")
    if os.path.exists(test_path):
        with open(test_path, "r") as f:
            reader = csv.reader(f)
            for line in reader:
                if line[0] not in INFO:
                    INFO[line[0]] = [0, 0, 0]
                INFO[line[0]][0] += 1
                if line[2] == 'True':
                    INFO[line[0]][1] += 1
                if line[2] == 'False':
                    INFO[line[0]][2] += 1
        break
    next_dir = os.path.dirname(dir)
    if next_dir == dir:
        print("No why3_auto_level_3.db.csv found")
        sys.exit(1)
    dir = next_dir
if dir == master_dir:
    print("No why3_auto_level_3.db.csv found")
    sys.exit(1)

RET = {}
for k, v in INFO.items():
    if k.startswith(target_path):
        kk = os.path.relpath(k, target_path)
        while True:
            if kk not in RET:
                RET[kk] = [0, 0, 0]
            RET[kk][0] += v[0]
            RET[kk][1] += v[1]
            RET[kk][2] += v[2]
            next_kk = os.path.dirname(kk)
            if next_kk == kk:
                break
            kk = next_kk

for k, v in sorted(RET.items()):
    success = v[1] / v[0] * 100
    path = os.path.join(target_dir, k)
    if success <= 30:
        print(f"\033[31m{path}: {v[0]} {v[2]} {success:.2f}%\033[0m")
    elif success <= 50:
        # Orange color using ANSI escape codes
        print(f"\033[38;5;208m{path}: {v[0]} {v[2]} {success:.2f}%\033[0m")
    elif success >= 80:
        pass
        # Light gray color using ANSI escape codes
        #print(f"\033[37m{k}: {v[0]} {v[2]} {success:.2f}%\033[0m")
    else:
        print(f"{path}: {v[0]} {v[2]} {success:.2f}%")




