#!/bin/env python3

import sys
import os
import csv
import json
import ast
csv.field_size_limit(sys.maxsize)

MASTER_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))

with open('test_set.isabelle.lst', 'r') as f:
    files = [line.strip() for line in f]

total = 0
HAVE = 0
CASES = 0
INDUCT = 0
with open('report.csv', 'w') as fw:
    writer = csv.writer(fw)
    with open('data/why3/pearl/SpNW.db.csv', 'r') as f:
        reader = csv.reader(f)
        reader.__next__()
        for line in reader:
            file = line[0].split(':')[0]
            file = os.path.relpath(file, MASTER_DIR)
            if file not in files:
                continue
            if line[1] == 'Status.SUCCESS':
                num = int(line[3])
                prfs = ast.literal_eval(line[5])
                proof = prfs[num]
                writer.writerow([file, num, proof])
                total += 1
                if 'HAVE' in proof:
                    HAVE += 1
                if 'CASE_SPLIT' in proof:
                    CASES += 1
                if 'INDUCT' in proof:
                    INDUCT += 1

print(f"Total: {total}, HAVE: {HAVE / total * 100:.2f}%")
print(f"CASES: {CASES / total * 100:.2f}%")
print(f"INDUCT: {INDUCT / total * 100:.2f}%")

