#!/bin/env python3

import os
import glob
import subprocess

def remove_lemmas():
    mlw_files = []
    pattern = os.path.join("./data/why3/common", "**/*.mlw")
    
    for file_path in glob.glob(pattern, recursive=True):
        relative_path = os.path.relpath(file_path, "./data/why3/common")
        no_lemma = os.path.join("./data/why3/no-lemma", relative_path)
        mlw_files.append((file_path, no_lemma))
    
    for (i,(file_path, no_lemma)) in enumerate(mlw_files):
        os.makedirs(os.path.dirname(no_lemma), exist_ok=True)
        cmd = ['why3', 'pp', '--output=mlw', file_path]
        result = subprocess.run(cmd, capture_output=True, text=True)
    
        if result.returncode != 0:
            print(f"why3 pp failed for {file_path}")
            print(f"stdout: {result.stdout}")
            print(f"stderr: {result.stderr}")
            continue
        
        with open(no_lemma, 'w') as f:
            f.write(result.stdout)
        print(f"[{i}/{len(mlw_files)}] {no_lemma}")
    
if __name__ == "__main__":
    remove_lemmas()
