#! /usr/bin/env python3
import os
import sys
from google import genai
from google.genai import types

if len(sys.argv) != 2:
    print("Usage: python upload_batch_Gemini.py jsonl_file")
    sys.exit(1)

jsonl_file = sys.argv[1]

client = genai.Client()
uploaded_file = client.files.upload(
    file=jsonl_file,
    config=types.UploadFileConfig(display_name=jsonl_file, mime_type='jsonl')
)

file_batch_job = client.batches.create(
    model="gemini-2.5-flash",
    src=uploaded_file.name,
    config={
        'display_name': jsonl_file
    },
)

job_name = file_batch_job.name
print(f"Job name: {job_name}")