import numpy as np
np.set_printoptions(suppress=True)

STEER_DISCRETIZATION = 36
ACCEL_DISCRETIZATION = 11
MAX_ACCEL = 10.0
MIN_ACCEL = -10.0
MAX_STEER = 0.7
MIN_STEER = -0.7

def undiscretize_actions(actions):
    # Initialize the array for the continuous actions
    actions_shape = (actions.shape[0], actions.shape[1], 2)
    continuous_actions = np.zeros(actions_shape)
    
    # Separate the combined actions back into their discretized components
    continuous_actions[:, :, 0] = actions // STEER_DISCRETIZATION # Acceleration component
    continuous_actions[:, :, 1] = actions % STEER_DISCRETIZATION   # Steering component

    # print(continuous_actions)
    
    # Reverse the discretization
    continuous_actions[:, :, 0] /= (ACCEL_DISCRETIZATION - 1)
    continuous_actions[:, :, 1] /= (STEER_DISCRETIZATION - 1)

    # print(continuous_actions)
    
    # Denormalize to get back the original continuous values
    continuous_actions[:, :, 0] = (continuous_actions[:, :, 0] * (MAX_ACCEL - MIN_ACCEL)) + MIN_ACCEL
    continuous_actions[:, :, 1] = (continuous_actions[:, :, 1] * (MAX_STEER - MIN_STEER)) + MIN_STEER

    # print(continuous_actions)
    
    return continuous_actions


def discretize_actions(actions):
    # normalize
    actions[:, :, 0] = ((np.clip(actions[:, :, 0], a_min=MIN_ACCEL, a_max=MAX_ACCEL) - MIN_ACCEL)
                            / (MAX_ACCEL - MIN_ACCEL))
    actions[:, :, 1] = ((np.clip(actions[:, :, 1], a_min=MIN_STEER, a_max=MAX_STEER) - MIN_STEER)
                            / (MAX_STEER - MIN_STEER))

    # print(actions)
    
    # discretize the actions
    actions[:, :, 0] = np.round(actions[:, :, 0] * (ACCEL_DISCRETIZATION - 1))
    actions[:, :, 1] = np.round(actions[:, :, 1] * (STEER_DISCRETIZATION - 1))

    # print(actions)

    # combine into a single categorical value
    actions = actions[:, :, 0] * STEER_DISCRETIZATION + actions[:, :, 1]

    # print(actions)

    return actions

actions = np.random.rand(1, 10, 2)
actions[:, :, 0] = actions[:, :, 0] * 20 - 10
actions[:, :, 1] = actions[:, :, 1] * 1.4 - 0.7

print(actions)

dis_actions = discretize_actions(actions)

print(dis_actions)

undis_actions = undiscretize_actions(dis_actions)

print(undis_actions)
