import json
import os
import sys
import time
import argparse
import pickle
import random
import shutil

import hydra
import imageio
import matplotlib.pyplot as plt
import numpy as np
import torch
import nocturne
import pdb
from tqdm import tqdm
from scipy.spatial import distance

# we need to split the val set into a val set and a test set (where we select 2500 scenes for the test set)
@hydra.main(version_base=None, config_path="/home/ctrl-sim-dev/cfgs/", config_name="config")
def main(cfg):
    test_filenames = os.listdir(cfg.nocturne_waymo_val_interactive_folder)
    test_filenames = [file for file in test_filenames if 'tfrecord' in file]
    test_filenames = sorted(test_filenames)

    print(len(test_filenames))

    seed = 2024
    random.seed(seed)  # Python random module.
    np.random.seed(seed)  # Numpy module.
    torch.manual_seed(seed)  # PyTorch.
    torch.cuda.manual_seed(seed)  # PyTorch, for CUDA.

    file_ids = list(np.arange(len(test_filenames)))
    random.shuffle(file_ids)
    test_file_ids = file_ids[:2500] # test set contains 2500 scenes

    # really just need the pickle file here
    test_files = [test_filenames[file_id] for file_id in test_file_ids]
    d = {'test_filenames': test_files}
    with open('/scratch/test_filenames_eval_planner.pkl', 'wb') as f:
        pickle.dump(d, f)

main()