"""
Priority-related logistics
"""
from multiprocessing import shared_memory
import numpy as np

_PRIORITY_MAX_SIZE = 200000

def init_priority_array():
    zero_arr = np.zeros((_PRIORITY_MAX_SIZE), dtype=np.float32)
    priority_shm = shared_memory.SharedMemory(create=True, name="priority-array", size=zero_arr.nbytes)
    return priority_shm

def close_priority_array(priority_shm):
    priority_shm.close()
    priority_shm.unlink()

def get_priority_array():
    priority_shm = shared_memory.SharedMemory(name="priority-array")
    priority = np.ndarray((_PRIORITY_MAX_SIZE,), dtype=np.float32, buffer=priority_shm.buf)
    return priority, priority_shm
