#!/bin/bash
set -ex
export CUDA_DEVICE_ORDER='PCI_BUS_ID'
export CUDA_VISIBLE_DEVICES=0,1,2,3,4,5,6,7
export OMP_NUM_THREADS=1
export NUM_WORKER_NODES=30

SHM_LABEL="trainer" python main.py --world_size ${NUM_TRAINERS} \
  --env ${ATARI_SCENARIO}NoFrameskip-v4 --case atari --opr train --force --num_worker_nodes ${NUM_WORKER_NODES} \
  --seed 0 \
  --use_priority \
  --use_max_priority \
  --amp_type 'torch_amp' \
  --info ${TRAIN_INFO}  \
  --batch_size ${BATCH_SIZE} --eff_batch_size ${EFF_BATCH_SIZE} --wandb_tags ${WANDB_TAGS} --run_id ${RUN_ID} \
  --result_dir "/data/SpeedyZero" | tee debug_${ATARI_SCENARIO}.log