#!/bin/bash
set -ex
export CUDA_DEVICE_ORDER='PCI_BUS_ID'
export CUDA_VISIBLE_DEVICES=0,1
export OMP_NUM_THREADS=1
export NUM_WORKER_NODES=30
# PongNoFrameskip-v4, BreakoutNoFrameskip-v4.
# BATCH_SIZE=256
# NUM_TRAINERS=4
# EFF_BATCH_SIZE=1024

SHM_LABEL="worker${WORKER_NODE_ID}" python main.py \
  --env ${ATARI_SCENARIO}NoFrameskip-v4 --case atari --opr worker --force \
  --cpu_actor 12 --gpu_actor 4 \
  --master_cpu_actor 0 --master_gpu_actor 0 --priority_updater 0 --value_updater 2 \
  --worker_node_id ${WORKER_NODE_ID} --num_worker_nodes ${NUM_WORKER_NODES} \
  --seed 0 --p_mcts_num 8 \
  --use_priority \
  --use_max_priority \
  --amp_type 'torch_amp' \
  --info ${TRAIN_INFO}  \
  --batch_size ${BATCH_SIZE} --eff_batch_size ${EFF_BATCH_SIZE} --wandb_tags ${WANDB_TAGS} --run_id ${RUN_ID} \
  --result_dir "/data/SpeedyZero"