# Contents
1. `/SMOS-SpeedyZero`: This directory contains code for the shared memory object store used in SpeedyZero.
It implements the **Efficient On-Node Communication with Shared Memory** mentioned in section 4.2
of the paper as a standalone Python package. More details about the design and implementation of
`SMOS-SpeedyZero` can be found in `/SMOS-SpeedyZero/README.md`

2. `/SpeedyZero`: This directory contains code for SpeedyZero. The code is based on the released
codebase of EfficientZero, with major modifications for distributed training and speed optimization.
Code for **Modular Design and Non-Trivial Workload Partition** are mainly in `/SpeedyZero/core/train.py`
and `/SpeedyZero/core/xnode.py`. **Data Transfer Optimizations** are more pervasive, with examples in
`/SpeedyZero/core/mcts.py` and `/SpeedyZero/core/reanalyze_worker.py`

# Usage
### Step 1: Modify Cluster Configuration
Set the IP for the trainer and workers in `/SpeedyZero/core/node_config.py`. If running inside a docker, the
following port mappings needs to be set when starting the docker (suppose the docker is running on `10.200.3.112`):
    
    -p 10.200.3.112:10002:5000/udp -p 10.200.3.112:10002:5000/tcp \
    -p 10.200.3.112:10003:5001/udp -p 10.200.3.112:10003:5001/tcp \
    -p 10.200.3.112:10004:5002/udp -p 10.200.3.112:10004:5002/tcp \
    -p 10.200.3.112:10005:5003/udp -p 10.200.3.112:10005:5003/tcp \
    -p 10.200.3.112:10006:5004/udp -p 10.200.3.112:10006:5004/tcp \
    -p 10.200.3.112:10007:5005/udp -p 10.200.3.112:10007:5005/tcp \
    -p 10.200.3.112:10008:5006/udp -p 10.200.3.112:10008:5006/tcp \
    -p 10.200.3.112:10009:5007/udp -p 10.200.3.112:10009:5007/tcp \
    -p 10.200.3.112:10010:5008/udp -p 10.200.3.112:10010:5008/tcp \
    -p 10.200.3.112:10011:5009/udp -p 10.200.3.112:10011:5009/tcp \
    -p 10.200.3.112:10012:5010/udp -p 10.200.3.112:10012:5010/tcp \
    -p 10.200.3.112:10013:5011/udp -p 10.200.3.112:10013:5011/tcp \
    -p 10.200.3.112:10014:5012/udp -p 10.200.3.112:10014:5012/tcp \
    -p 10.200.3.112:10015:5013/udp -p 10.200.3.112:10015:5013/tcp \
    -p 10.200.3.112:10016:5014/udp -p 10.200.3.112:10016:5014/tcp \
    -p 10.200.3.112:10017:5015/udp -p 10.200.3.112:10017:5015/tcp \
    -p 10.200.3.112:10018:5016/udp -p 10.200.3.112:10018:5016/tcp \
    -p 10.200.3.112:10019:5017/udp -p 10.200.3.112:10019:5017/tcp \
    -p 10.200.3.112:10020:5018/udp -p 10.200.3.112:10020:5018/tcp \
    -p 10.200.3.112:13000:4000/udp -p 10.200.3.112:13000:4000/tcp \



### Step 4: Run the test
Command to run the trainer:
    
    NODE_CONFIG_ID=$3 ATARI_SCENARIO=$1 RUN_ID=$2 BATCH_SIZE=128 NUM_TRAINERS=4 EFF_BATCH_SIZE=512 TRAIN_INFO="512-20k-100k-test" WANDB_TAGS="512-20k-100k-test" bash train.sh

Command to run the workers:

    NODE_CONFIG_ID=$4 ATARI_SCENARIO=$1 RUN_ID=$3 BATCH_SIZE=128 NUM_TRAINERS=4 EFF_BATCH_SIZE=512 TRAIN_INFO="512-20k-100k-test" WANDB_TAGS="512-20k-100k-test" WORKER_NODE_ID=$2 bash worker0.sh