

def merge_dictionaries(dict1, dict2):
    """
    Recursive merge dictionaries.

    :param dict1: Base dictionary to merge.
    :param dict2: Dictionary to merge on top of base dictionary.
    :return: Merged dictionary
    """
    for key, val in dict1.items():
        if isinstance(val, dict):
            dict2_node = dict2.setdefault(key, {})
            merge_dictionaries(val, dict2_node)
        else:
            if key not in dict2:
                dict2[key] = val

    return dict2


class Namespace:
    def __init__(self, **kwargs):
        self.__dict__.update(kwargs)

    def update(self, other):
        self.__dict__ = merge_dictionaries(self.__dict__, other)

    def __repr__(self):
        return str(self.__dict__)

    def dict(self):
        return self.__dict__

    def copy(self):
        return Namespace(**self.__dict__)


default_args = {
    "model_dir": "./model_dir",
    "model_args": {
        'num_iter': 1e7,
    }
}


def get_default_args():
    return Namespace(**default_args)


def build_args_from_stack(arg_stack):
    args = get_default_args()
    for a in reversed(arg_stack):
        args.update(a)
    return args
