# A Benchmark Study For Limit Order Book (LOB) Models and Time Series Forecasting Models on LOB Data

Before running any tasks, please run the following to install the package
```
pip install -e .
pip install -r requirements.txt
```

## Dataset Downloads

To run experiments on FI-2010, download the dataset from https://etsin.fairdata.fi/dataset/73eb48d7-4dbc-4a10-a52a-da745b47a649/data. Unzip the data and add it to the `data` folder.

To run experiments on bitcoin BTCUSDT.P, donwload the dataset from https://www.kaggle.com/datasets/siavashraz/bitcoin-perpetualbtcusdtp-limit-order-book-data. Move the downloaded csv file to the `data` folder. For reproducibility, run the following to normalize the script for either mid price trend prediction or mid price return forecasting.
```
python -m btc_preprocess
```


## Mid-Price Return Forecasting
To run any MPRF task, please use the following command:
```
cd ./mprf
python -m mprf_run <model> <dataset> [options]
```

For example, to run the iTransformer model with CVML on the FI-2010 dataset for horizon 10 on seed 5, do:
```
python -m mprf_run --model=itransformer_conv --dataset=FI --horizon=10 --seed=5
```

More arguments can be found in the mprf_run.py file to modify hyperparameters.

## Mid-Price Trend Prediction
To run mid-price trend prediction, run the following:
```
python -m mptp.main_run_exp [models] [options]
```

For example, to run the TransLOB model on the FI-2010 dataset for horizons 1, 2, and 3 on seed 1, do:
```
python -m src.main_run_exp translob --horizons=1,2,3 --seeds=1 --dataset=FI

More arguments can be found in the main_run_exp.py file to modify the number of features, do hyperparameter tuning, turn on WANDB logging, and changing the save directory.