import torch
import torch.nn as nn
import torch.nn.functional as F

class MLP_Lob(nn.Module):
    def __init__(self, in_c=41, out_c=14, num_layers=5):
        super(MLP_Lob, self).__init__()
        mlp_layers = []
        for i in range(num_layers):
            mlp_layers.extend([nn.Linear(in_c, out_c),
                               nn.ReLU()
                                ])
            

        self.mlp_layers = nn.Sequential(*mlp_layers)

        print(self.mlp_layers)

    def forward(self, x):
        # B, L, D

        x = torch.permute(x, (0, 2, 1))     # B, L, D --> B, D, L
        x = self.mlp_layers(x)
        x = torch.permute(x, (0, 2, 1))     # B, D, L --> B, L, D

        return x

