SHELL := /bin/bash

PROJECT_NAME := bfn4planar_hyper
SAVEROOT := logs/${PROJECT_NAME}

test_bfn_planar:
	$(eval GPU_ID := 4)
	$(eval EXP_NAME := $@) 
	$(eval BATCH_SIZE := 64)
	$(eval SAMPLING_BS := 512)
	$(eval EPOCHS := 2000)
	${eval SAMPLE_STEPS := 1000}
	${eval LR := 0.0002}
	${eval CLIP_GRAD := 1.0}
	${eval EMA_DECAY := 0.999}
	${eval TEST_CKPT_FNAME := }
	${eval BETA = 7.0}
	${eval BETA_INIT = 2.0}
	${eval LAMBDAX = 1.0}
	${eval LAMBDAE = 1.0}
	${eval PRIOR = marginal}
	${eval EXTRA_FEATURES = all}
	${eval EXTRA_MODE = direct}
	${eval TIME_SCHEDULER = linear}
	${eval ALTERNATIVE_RATIO = 0.5}
	${eval CONFIG_FILE := configs/bfn_planar.yaml}
	${eval REVISION := ${shell git rev-parse --short HEAD}}
	CUDA_VISIBLE_DEVICES=${GPU_ID} python src/main.py --config_file ${CONFIG_FILE} \
		--exp_name ${EXP_NAME}_${REVISION}_alternative${ALTERNATIVE_RATIO}_beta${BETA}__prior=${PRIOR}_feat=${EXTRA_FEATURES}-${EXTRA_MODE}_${TIME_SCHEDULER}_step${SAMPLE_STEPS} \
		--batch_size ${BATCH_SIZE} --epochs ${EPOCHS} --sample_steps ${SAMPLE_STEPS} --lr ${LR} --clip_grad ${CLIP_GRAD} --ema_decay ${EMA_DECAY} --sampling_bs ${SAMPLING_BS}\
		--test_ckpt_fname ${TEST_CKPT_FNAME} \
		--beta_node ${BETA} --beta_edge ${BETA} \
		--lambda_train_node ${LAMBDAX} --lambda_train_edge ${LAMBDAE} \
		--prior ${PRIOR} --extra_features ${EXTRA_FEATURES} --extra_mode ${EXTRA_MODE}\
		--node_time_scheduler ${TIME_SCHEDULER} --edge_time_scheduler ${TIME_SCHEDULER} \
		--force_symmetric_theta_E --alternative_sampling_theta_update_ratio ${ALTERNATIVE_RATIO} --beta_node_init ${BETA_INIT} --beta_edge_init ${BETA_INIT} \
		--plot_input_dist_entropy --input_dist_sample --compare_input_output_dist_samples 
