SHELL := /bin/bash

## QM9 Basic ----------------------------------------------------------------------------------------
train_bfn_qm9withh:
	$(eval GPU_ID:= 0 )
	$(eval EXP_NAME:= $@) 
	$(eval BATCH_SIZE := 256)
	$(eval SAMPLING_BS := 1024)
	$(eval EPOCHS := 2000)
	${eval SAMPLE_STEPS := 500}
	${eval LR := 0.0002}
	${eval CLIP_GRAD := 1.0}
	${eval EMA_DECAY := 0.999}
	${eval BETAX = 2.0}
	${eval BETAE = 2.0}
	${eval BETAX_INIT = 2.0}
	${eval BETAE_INIT = 2.0}
	${eval LAMBDAX = 1.0}
	${eval LAMBDAE = 5.0}
	${eval PRIOR = marginal}
	${eval EXTRA_FEATURES = null}
	${eval EXTRA_MODE = direct}
	${eval N_IID =16}
	${eval NODE_TIME_SCHEDULER = quad}
	${eval EDGE_TIME_SCHEDULER = quad}
	${eval ALTERNATIVE_RATIO = 1.0}
	${eval CONFIG_FILE := configs/bfn_qm9withh.yaml}
	${eval REVISION := ${shell git rev-parse --short HEAD}}
	CUDA_VISIBLE_DEVICES=${GPU_ID} python src/main.py --config_file ${CONFIG_FILE} \
		--exp_name ${EXP_NAME}_${REVISION}_n${BETAX}_e${BETAE}_ln${LAMBDAX}_le${LAMBDAE}_prior=${PRIOR}_feat=${EXTRA_FEATURES}-${EXTRA_MODE}-${N_IID}_${NODE_TIME_SCHEDULER}_${EDGE_TIME_SCHEDULER} \
		--batch_size ${BATCH_SIZE} --epochs ${EPOCHS} --sample_steps ${SAMPLE_STEPS} --lr ${LR} --clip_grad ${CLIP_GRAD} --ema_decay ${EMA_DECAY} --sampling_bs ${SAMPLING_BS}\
		--beta_node ${BETAX} --beta_edge ${BETAE} \
		--beta_node_init ${BETAX_INIT} --beta_edge_init ${BETAE_INIT} \
		--lambda_train_node ${LAMBDAX} --lambda_train_edge ${LAMBDAE} \
		--prior ${PRIOR} --extra_features ${EXTRA_FEATURES} --extra_mode ${EXTRA_MODE} --n_iid ${N_IID} \
		--node_time_scheduler ${NODE_TIME_SCHEDULER} --edge_time_scheduler ${EDGE_TIME_SCHEDULER} \
		--force_symmetric_theta_E --alternative_sampling_theta_update_ratio ${ALTERNATIVE_RATIO} \


test_bfn_qm9withh:
	$(eval GPU_ID:= 0 )
	$(eval EXP_NAME:= $@) 
	$(eval BATCH_SIZE := 256)
	$(eval SAMPLING_BS := 1024)
	$(eval EPOCHS := 2000)
	${eval SAMPLE_STEPS := 500}
	${eval LR := 0.0002}
	${eval CLIP_GRAD := 1.0}
	${eval EMA_DECAY := 0.999}
	${eval TEST_CKPT_FNAME := }
	${eval BETAX = 2.0}
	${eval BETAE = 2.0}
	${eval BETAX_INIT = 2.0}
	${eval BETAE_INIT = 2.0}
	${eval LAMBDAX = 1.0}
	${eval LAMBDAE = 5.0}
	${eval PRIOR = marginal}
	${eval EXTRA_FEATURES = null}
	${eval EXTRA_MODE = direct}
	${eval N_IID =16}
	${eval NODE_TIME_SCHEDULER = quad}
	${eval EDGE_TIME_SCHEDULER = quad}
	${eval ALTERNATIVE_RATIO = 1.0}
	${eval CONFIG_FILE := configs/bfn_qm9withh.yaml}
	${eval REVISION := ${shell git rev-parse --short HEAD}}
	CUDA_VISIBLE_DEVICES=${GPU_ID} python src/main.py --config_file ${CONFIG_FILE} \
		--exp_name ${EXP_NAME}_${REVISION}_n${BETAX}_e${BETAE}_ln${LAMBDAX}_le${LAMBDAE}_prior=${PRIOR}_feat=${EXTRA_FEATURES}-${EXTRA_MODE}-${N_IID}_${NODE_TIME_SCHEDULER}_${EDGE_TIME_SCHEDULER} \
		--batch_size ${BATCH_SIZE} --epochs ${EPOCHS} --sample_steps ${SAMPLE_STEPS} --lr ${LR} --clip_grad ${CLIP_GRAD} --ema_decay ${EMA_DECAY} --sampling_bs ${SAMPLING_BS}\
		--test_ckpt_fname ${TEST_CKPT_FNAME} \
		--beta_node ${BETAX} --beta_edge ${BETAE} \
		--beta_node_init ${BETAX_INIT} --beta_edge_init ${BETAE_INIT} \
		--lambda_train_node ${LAMBDAX} --lambda_train_edge ${LAMBDAE} \
		--prior ${PRIOR} --extra_features ${EXTRA_FEATURES} --extra_mode ${EXTRA_MODE} --n_iid ${N_IID} \
		--node_time_scheduler ${NODE_TIME_SCHEDULER} --edge_time_scheduler ${EDGE_TIME_SCHEDULER} \
		--force_symmetric_theta_E --alternative_sampling_theta_update_ratio ${ALTERNATIVE_RATIO} \