SHELL := /bin/bash

train_bfn_moses_multigpu:
	$(eval EXP_NAME:= $@) 
	$(eval BATCH_SIZE := 128)
	$(eval GRAD_ACCUMULATE_STEPS := 2) #
	$(eval SAMPLING_BS := 256)
	$(eval EPOCHS := 300)
	${eval SAMPLE_STEPS := 500}
	${eval LR := 0.0002}
	${eval CLIP_GRAD := 1.0}
	${eval EMA_DECAY := 0.999}
	${eval BETAX = 1.0}
	${eval BETAE = 7.0}
	${eval LAMBDAX = 1.0}
	${eval LAMBDAE = 7.0}
	${eval PRIOR = uniform}
	${eval EXTRA_FEATURES = null}
	${eval EXTRA_MODE = max}
	${eval NODE_TIME_SCHEDULER = quad}
	${eval EDGE_TIME_SCHEDULER = quad}
	${eval CONFIG_FILE := configs/bfn_moses.yaml}
	${eval REVISION := ${shell git rev-parse --short HEAD}}
	${eval GPUS := 4,5,6,7}
	CUDA_VISIBLE_DEVICES=${GPUS} python src/main.py --config_file ${CONFIG_FILE} \
		--exp_name ${EXP_NAME}_${REVISION}_n${BETAX}_e${BETAE}_ln${LAMBDAX}_le${LAMBDAE}_prior=${PRIOR}_feat=${EXTRA_FEATURES}-${EXTRA_MODE}_${NODE_TIME_SCHEDULER}_${EDGE_TIME_SCHEDULER}_step${SAMPLE_STEPS}_lr${LR}_clipgrad${CLIP_GRAD}_ema${EMA_DECAY} \
		--batch_size ${BATCH_SIZE} --epochs ${EPOCHS} --sample_steps ${SAMPLE_STEPS} \
		--lr ${LR} --clip_grad ${CLIP_GRAD} --ema_decay ${EMA_DECAY} --sampling_bs ${SAMPLING_BS} \
		--beta_node ${BETAX} --beta_edge ${BETAE} \
		--lambda_train_node ${LAMBDAX} --lambda_train_edge ${LAMBDAE} \
		--prior ${PRIOR} --extra_features ${EXTRA_FEATURES} --extra_mode ${EXTRA_MODE} \
		--node_time_scheduler ${NODE_TIME_SCHEDULER} --edge_time_scheduler ${EDGE_TIME_SCHEDULER} \
		--force_symmetric_theta_E \
		--accumulate_grad_batches ${GRAD_ACCUMULATE_STEPS} \
		--logging_level info
	
	

train_bfn_moses_8gpu:
	$(eval EXP_NAME:= $@) 
	$(eval BATCH_SIZE := 128)
	$(eval GRAD_ACCUMULATE_STEPS := 1) #
	$(eval SAMPLING_BS := 256)
	$(eval EPOCHS := 300)
	${eval SAMPLE_STEPS := 500}
	${eval LR := 0.0002}
	${eval CLIP_GRAD := 1.0}
	${eval EMA_DECAY := 0.999}
	${eval BETAX = 2.0}
	${eval BETAE = 2.0}
	${eval LAMBDAX = 1.0}
	${eval LAMBDAE = 5.0}
	${eval PRIOR = uniform}
	${eval EXTRA_FEATURES = null}
	${eval EXTRA_MODE = direct}
	${eval NODE_TIME_SCHEDULER = quad}
	${eval EDGE_TIME_SCHEDULER = quad}
	${eval CONFIG_FILE := configs/bfn_moses.yaml}
	${eval REVISION := ${shell git rev-parse --short HEAD}}
	${eval GPUS := 0,1,2,3,4,5,6,7}
	CUDA_VISIBLE_DEVICES=${GPUS} python src/main.py --config_file ${CONFIG_FILE} \
		--exp_name ${EXP_NAME}_${REVISION}_n${BETAX}_e${BETAE}_ln${LAMBDAX}_le${LAMBDAE}_prior=${PRIOR}_feat=${EXTRA_FEATURES}-${EXTRA_MODE}_${NODE_TIME_SCHEDULER}_${EDGE_TIME_SCHEDULER}_step${SAMPLE_STEPS}_lr${LR}_clipgrad${CLIP_GRAD}_ema${EMA_DECAY} \
		--batch_size ${BATCH_SIZE} --epochs ${EPOCHS} --sample_steps ${SAMPLE_STEPS} \
		--lr ${LR} --clip_grad ${CLIP_GRAD} --ema_decay ${EMA_DECAY} --sampling_bs ${SAMPLING_BS} \
		--beta_node ${BETAX} --beta_edge ${BETAE} \
		--lambda_train_node ${LAMBDAX} --lambda_train_edge ${LAMBDAE} \
		--prior ${PRIOR} --extra_features ${EXTRA_FEATURES} --extra_mode ${EXTRA_MODE} \
		--node_time_scheduler ${NODE_TIME_SCHEDULER} --edge_time_scheduler ${EDGE_TIME_SCHEDULER} \
		--force_symmetric_theta_E \
		--accumulate_grad_batches ${GRAD_ACCUMULATE_STEPS} 