SHELL := /bin/bash

PROJECT_NAME := bfn4sbm_hyper
SAVEROOT := ogs/${PROJECT_NAME}



train_digress_sbm:
	$(eval GPU_ID := 6)
	$(eval EXP_NAME := $@) 
	$(eval BATCH_SIZE := 8)
	$(eval SAMPLING_BS := 32)
	$(eval EPOCHS := 100000)
	${eval SAMPLE_STEPS := 1000}
	${eval LR := 0.0002}
	${eval CLIP_GRAD := 1.0}
	${eval EMA_DECAY := 0.999}
	${eval LAMBDAX = 1.0}
	${eval LAMBDAE = 1.0}
	${eval PRIOR = marginal}
	${eval EXTRA_FEATURES = all}
	${eval CONFIG_FILE := configs/digress_sbm.yaml}
	${eval REVISION := ${shell git rev-parse --short HEAD}}
	CUDA_VISIBLE_DEVICES=${GPU_ID} python src/main.py --config_file ${CONFIG_FILE} \
		--exp_name ${EXP_NAME}_${REVISION}_prior=${PRIOR}_feat=${EXTRA_FEATURES}_step${SAMPLE_STEPS}_lr${LR}_clipgrad${CLIP_GRAD}_ema${EMA_DECAY} \
		--batch_size ${BATCH_SIZE} --epochs ${EPOCHS} --sample_steps ${SAMPLE_STEPS} --lr ${LR} --clip_grad ${CLIP_GRAD} --ema_decay ${EMA_DECAY} --sampling_bs ${SAMPLING_BS}\
		--lambda_train_node ${LAMBDAX} --lambda_train_edge ${LAMBDAE} \
		--prior ${PRIOR} --extra_features ${EXTRA_FEATURES} 

train_bfn_sbm_resume2599:
	$(eval GPU_ID := 5)
	$(eval EXP_NAME := $@) 
	$(eval BATCH_SIZE := 8)
	$(eval SAMPLING_BS := 32)
	$(eval EPOCHS := 100000)
	${eval SAMPLE_STEPS := 1000}
	${eval LR := 0.0002}
	${eval CLIP_GRAD := 1.0}
	${eval EMA_DECAY := 0.999}
	${eval RESUME := }
	${eval BETA = 3.0}
	${eval BETA_INIT = 1.0}
	${eval LAMBDAX = 1.0}
	${eval LAMBDAE = 1.0}
	${eval PRIOR = uniform}
	${eval EXTRA_FEATURES = all}
	${eval EXTRA_MODE = direct}
	${eval TIME_SCHEDULER = linear}
	${eval ALTERNATIVE_RATIO = 1.0}
	${eval CONFIG_FILE := configs/bfn_sbm.yaml}
	${eval REVISION := ${shell git rev-parse --short HEAD}}
	CUDA_VISIBLE_DEVICES=${GPU_ID} python src/main.py --config_file ${CONFIG_FILE} \
		--exp_name ${EXP_NAME}_${REVISION}_beta${BETA}__prior=${PRIOR}_feat=${EXTRA_FEATURES}-${EXTRA_MODE}_${TIME_SCHEDULER}_step${SAMPLE_STEPS}_lr${LR}_clipgrad${CLIP_GRAD}_ema${EMA_DECAY} \
		--batch_size ${BATCH_SIZE} --epochs ${EPOCHS} --sample_steps ${SAMPLE_STEPS} --lr ${LR} --clip_grad ${CLIP_GRAD} --ema_decay ${EMA_DECAY} --sampling_bs ${SAMPLING_BS} \
		--resume ${RESUME} \
		--beta_node ${BETA} --beta_edge ${BETA} \
		--lambda_train_node ${LAMBDAX} --lambda_train_edge ${LAMBDAE} \
		--prior ${PRIOR} --extra_features ${EXTRA_FEATURES} --extra_mode ${EXTRA_MODE}\
		--node_time_scheduler ${TIME_SCHEDULER} --edge_time_scheduler ${TIME_SCHEDULER} \
		--force_symmetric_theta_E --alternative_sampling_theta_update_ratio ${ALTERNATIVE_RATIO} --beta_node_init ${BETA_INIT} --beta_edge_init ${BETA_INIT} \
		--output_dist_extra