# Hierarchical Mixture-of-Experts

## Set Up Environment

Run the following commands to create a conda environment:
```bash
conda create -n HMoE python=3.8
source activate HMoE
pip install -r requirements.txt
```

## Repository Structure

- `src/`: Source code
    - `preprocessing/`: Scripts for data preprocessing
    - `core/`: Core implementation for the HMoE/MoE and modality encoder module
    - `scripts/`: Scripts to run experiments in different settings
    - `utils/`: Hyper-parameters, I/O, utility functions

## Run Experiments

Under `src/scripts/`:

MIMIC-III experiments
```
sh run.sh
```

MIMIC-IV experiments
```
sh run_mimiciv.sh
```

## Load Results
First change the `filepath` in `load_result.py`, then run
```
python load_result.py
```