% Experiment 1. DSEPL/DSEGD vs. SEPL/SEGD outer running script (BlindDeconv)
clear; clc; close all;

% Experiment information
exp_time = datetime;
exp_name = "E1. DSEPL/DSEGD vs. SEPL/SEGD outer running script (BlindDeconv)";

% Data configuration
kapparange = [1, 10];
pfailrange = [2, 3];

addpath(fullfile('..', '..', 'data'));

ntest      = 20;
nalpha     = 10;
alpharange = logspace(0, 1, nalpha);
betarange  = [0.6];
maxiter    = 400;
early_stop = true;
tauubrange = logspace(1, 3, 10);
typerange  = ['p', 'g'];
show_info  = false;

for kappa = kapparange
    for pfail = pfailrange
        load("blind_kappa_" + kappa + "_pfail_" + pfail + ".mat");
        
        rng(100);
        
        U = data.U;
        V = data.V;
        b = data.b;
        [m, n] = size(U);
        
        init_z = randn(2 * n, 1);
        init_z = init_z / norm(init_z);
        gamma = sqrt(maxiter * m);
        tol = data.bestloss * 1.5;
        
        for beta = betarange
            for ub = tauubrange
                tauub = ceil(ub);
                for type = typerange
                    tic;
                    
                    if type == 'p'
                        p = tauub / 2;
                    elseif type == 'c'
                        p = 0.0;
                    else
                        p = 2 / tauub;
                    end % End if
                    
                    taups = genpmf(p, ceil(tauub), type);
                    
                    sub_exp = "E1. beta: " + beta +...
                        " tauub: " + tauub + " type: " + type;
                    mat_name = "E1_kappa_" + kappa + "_pfail_" + pfail + "_beta_" + beta * 10 +...
                        "_tauub_" + tauub + "_type_" + type + ".mat";
                    exp_inner_1_blind;
                    t = toc;
                    fprintf("T: %f\n\n", t);
                    
                end % End for
            end % End for
        end % End for
        
    end % End for
end % End for






