function [] = addAlg(stats, xrange, alg, scale)
if nargin < 4
    scale = 'semilogx';
end % End if

meanval = stats.meanval;
stdval = stats.stdval;

lprop = getLineProperty(alg);

if scale == "semilogx"
    shadedErrorBarSemi(xrange, meanval, stdval, "LineProps", lprop);
elseif scale == "linear"
    shadedErrorBar(xrange, meanval, stdval, "LineProps", lprop);
else
    error('scale is not implemented');
end % End if 

hold on;

end % End function