% Experiment 1. DSEPL/DSEGD vs. SEPL/SEGD outer analysis script (ZIPCODE)
mat_name = "E1_zip_" + code + "_pfail_" + pfail + "_beta_" + beta * 10 +...
                        "_tauub_" + tauub + "_type_" + type + ".mat";
load(fullfile(resdir, mat_name));


% First plot. Compare SEGD/SEPL and SGD/SPL
sgdstat   = getErrbarData(sgditer2opt);
splstat   = getErrbarData(spliter2opt);
segdstat  = getErrbarData(segditer2opt);
seplstat  = getErrbarData(sepliter2opt);
dsgdstat  = getErrbarData(dsgditer2opt);
dsplstat  = getErrbarData(dspliter2opt);
dsegdstat = getErrbarData(dsegditer2opt);
dseplstat = getErrbarData(dsepliter2opt);

% addAlg(sgdstat, alpharange, "sgd");
% addAlg(splstat, alpharange, "spl");
addAlg(dsgdstat, alpharange, "dsgd");
addAlg(dsplstat, alpharange, "dspl");

% addAlg(segdstat, alpharange, "segd");
% addAlg(seplstat, alpharange, "sepl");
addAlg(dsegdstat, alpharange, "dsegd");
addAlg(dseplstat, alpharange, "dsepl");

legend([
        % "SGD",...
        % "SPL",...
        "DSGD"; 
        "DSPL";
        % "SEGD",...
        % "SEPL",...
        "DSEGD";
        "DSEPL";
        ],...
        "FontSize", 20);
set(gca, "FontSize", 20, "FontWeight", "bold");
ylim([0, maxiter * m]);
tightfig;

fname = split(mat_name);
fname = fname(1);

hold off;
savefig(mat_name + 'type_1.fig');
close all;