% Experiment 1. DSEPL/DSEGD vs. SEPL/SEGD outer running script
clear; clc; close all;

% Experiment information
exp_time = datetime;
exp_name = "E1. DSEPL/DSEGD vs. SEPL/SEGD outer running script";

% Data configuration
kappa = 10;
pfail = 3;

addpath(fullfile('..', 'data'));
load("kappa_" + kappa + "_pfail_" + pfail + ".mat");

rng(100);

A = data.A;
b = data.b;
[m, n] = size(A);

ntest      = 2;
nalpha     = 2;
init_x     = randn(n, 1);
init_x     = init_x / norm(init_x);
alpharange = logspace(-2, 1, nalpha);
betarange  = [0.2, 0.6];
maxiter    = 100;
early_stop  = true;
tauubrange = [10, 50, 100];
typerange  = ['p', 'c', 'g'];
show_info  = false;

gamma = sqrt(maxiter * m);
tol = data.bestloss * 1.2;

for beta = betarange
    for tauub = tauubrange
        for type = typerange
            tic;
            
            if type == 'p'
                p = tauub / 2;
            elseif type == 'c'
                p = 0.0;
            else
                p = 2 / tauub;
            end % End if
            
            taups = genpmf(p, tauub, type);
            
            sub_exp = "E1. beta: " + beta +...
                " tauub: " + tauub + " type: " + type;
            mat_name = "E1_kappa_" + kappa + "_pfail_" + pfail + "_beta_" + beta * 10 +...
                "_tauub_" + tauub + "_type_" + type + ".mat";
            exp_inner_1;
            t = toc;
            fprintf("T: %f\n\n", t);
            
        end % End for
    end % End for
end % End for







