clear; clc; close all;

addpath(fullfile('..', 'data'));
load zipcode_64_pfail_2.mat;

rng(100);

A = data.A;
b = data.b;
[m, n] = size(A);
maxiter = 400;
gamma = sqrt(maxiter * m);
beta = 0.9;
init_x = data.optx + randn(n, 1);
% init_x = init_x / norm(init_x);
tol = data.bestloss * 1.5;
early_stop = true;
alpha_0 = 10;
show_info = true;

% Density of distribution of tau
% e.g. [x, y, z], x + y + z = 1.0, z is the chance of no delay
tauub = 10;
type = 'g'; % 'c', 'g'

taups = genpmf(0.2, tauub, type);

[sgdsol, sgdinfo] = proxsgd(A, b, gamma, beta, init_x, maxiter, tol, ...
    early_stop, alpha_0, show_info);
[sgdsoltau, sgdinfotau] = proxsgdtau(A, b, gamma, beta, init_x, maxiter, tol, ...
    early_stop, alpha_0, taups, show_info);
[plsol, plinfo] = proxlin(A, b, gamma, beta, init_x, maxiter, tol, ...
    early_stop, alpha_0, show_info);
[plsoltau, plinfotau] = proxlintau(A, b, gamma, beta, init_x, maxiter, tol, ...
    early_stop, alpha_0, taups, show_info);

% plot(1:maxiter * m + 1, sgdinfo.objs, 'LineWidth', 2);
% hold on;
% plot(1:maxiter * m + 1, sgdinfotau.objs, 'LineWidth', 2);
% semilogy(1:maxiter * m + 1, plinfo.objs, 'LineWidth', 2);
% semilogy(1:maxiter * m + 1, plinfotau.objs, 'LineWidth', 2);
% legend(["SGD", "SGD delay", "SPL", "SPL delay"]);
% xlim([1, maxiter * m + 1]);



