function [ps] = genpmf(p, tauup, type)
% Generate distribution of tau

if type == 'c'
    % Categorial distribution
    ps = ones(tauup, 1) / tauup;
elseif type == 'p'
    % Poisson distribution
    ps = zeros(tauup, 1);
    for i = 1:tauup - 1
        ps(i + 1) = poisspdf(tauup - i - 1, p);
    end % End for
    ps(1) = 1 - sum(ps(2:end));
else
    % Geometric distribution
    ps = zeros(tauup, 1);
    for i = 1:tauup - 1
        ps(i + 1) = geopdf(tauup - i - 1, p);
    end % End for
    ps(1) = 1 - sum(ps(2:end));
end % End if 

ps = cumsum(ps);

end % End function