% Experiment 1. DSEPL/DSEGD vs. SEPL/SEGD analysis script
% Plot how the delay impacts the algorithms

kappa = 10;
pfail = 2;
beta = 0.6;
ntest = 20;
tauubrange = logspace(1, 3, 10);
type  = 'p';

sgditerbydelay = zeros(11, 1);
segditerbydelay = zeros(11, 1);
spliterbydelay = zeros(11, 1);
sepliterbydelay = zeros(11, 1);

idx = 1;
alphaidx = 7;
for ub = tauubrange
    idx = idx + 1;
    tauub = ceil(ub);
    mat_name = "E1_kappa_" + kappa + "_pfail_" + pfail + "_beta_" + beta * 10 +...
        "_tauub_" + tauub + "_type_" + type + ".mat";
    info = load(mat_name);
    
    sgdstat   = mean(info.sgditer2opt);
    splstat   = mean(info.spliter2opt);
    segdstat  = mean(info.segditer2opt);
    seplstat  = mean(info.sepliter2opt);
    dsgdstat  = mean(info.dsgditer2opt);
    dsplstat  = mean(info.dspliter2opt);
    dsegdstat = mean(info.dsegditer2opt);
    dseplstat = mean(info.dsepliter2opt);
    
    sgditerbydelay(1)  = sgditerbydelay(1) + sgdstat(alphaidx) / 10;
    segditerbydelay(1) = sgditerbydelay(1) + segdstat(alphaidx) / 10;
    spliterbydelay(1)  = spliterbydelay(1) + splstat(alphaidx) / 10;
    sepliterbydelay(1) = sepliterbydelay(1) + seplstat(alphaidx) / 10;
    
    sgditerbydelay(idx)  = dsgdstat(alphaidx);
    segditerbydelay(idx) = dsegdstat(alphaidx);
    spliterbydelay(idx)  = dsplstat(alphaidx);
    sepliterbydelay(idx) = dseplstat(alphaidx);
    
%     sgditerbydelay(1)  = sgditerbydelay(1) + sgdstat / 10;
%     segditerbydelay(1) = sgditerbydelay(1) + segdstat / 10;
%     spliterbydelay(1)  = spliterbydelay(1) + splstat / 10;
%     sepliterbydelay(1) = sepliterbydelay(1) + seplstat / 10;
%     
%     sgditerbydelay(idx)  = dsgdstat;
%     segditerbydelay(idx) = dsegdstat;
%     spliterbydelay(idx)  = dsplstat;
%     sepliterbydelay(idx) = dseplstat;
    
end % End if

% tauubrange = [0, tauubrange];
len = length(tauubrange);
lprop = getLineProperty("sgd");
semilogx(tauubrange, sgditerbydelay(1:len), lprop{1}, lprop{2},...
    lprop{3}, lprop{4}, lprop{5}, lprop{6}, lprop{7});
hold on;
lprop = getLineProperty("segd");
semilogx(tauubrange, segditerbydelay(1:len), lprop{1}, lprop{2},...
    lprop{3}, lprop{4}, lprop{5}, lprop{6}, lprop{7});
lprop = getLineProperty("spl");
semilogx(tauubrange, spliterbydelay(1:len), lprop{1}, lprop{2},...
    lprop{3}, lprop{4}, lprop{5}, lprop{6}, lprop{7});
lprop = getLineProperty("sepl");
semilogx(tauubrange, sepliterbydelay(1:len), lprop{1}, lprop{2},...
    lprop{3}, lprop{4}, lprop{5}, lprop{6}, lprop{7});

legend([
        % "SGD",...
        % "SPL",...
        "SGD"; 
        "SEGD";
        % "SEGD",...
        % "SEPL",...
        "SPL";
        "SEPL";
        ],...
        "FontSize", 20);
set(gca, "FontSize", 20, "FontWeight", "bold");
tightfig;
savefig("E1_kappa_" + kappa + "_pfail_" + pfail + "_delay_" + type  + "_type_2.fig");
% close all;
