import numpy as np
import pandas as pd
import datetime

from value_based.commons.args import DIM_FAKE_USER, NUM_FAKE_USERS, NUM_FAKE_ITEMS, FAKE_CATEGORY_NAMES, \
    HISTORY_SIZE, DIM_ITEM_DEEP, DIM_ITEM_WIDE

# generate fake users
user_attr = np.random.randn(NUM_FAKE_USERS, DIM_FAKE_USER)
np.save(file="user_attr", arr=user_attr)

# generate fake items
deep, wide = np.random.randn(NUM_FAKE_ITEMS, DIM_ITEM_DEEP), np.random.randn(NUM_FAKE_ITEMS, DIM_ITEM_WIDE)
np.save(file="offline_deep_attr", arr=deep)
np.save(file="online_deep_attr", arr=deep)
np.save(file="offline_wide_attr", arr=wide)
np.save(file="online_wide_attr", arr=wide)

master = dict()
for col in FAKE_CATEGORY_NAMES:
    _sample = np.random.randint(low=0, high=3, size=NUM_FAKE_ITEMS)
    master[col] = _sample

df = pd.DataFrame(master)
df.to_csv("item_category.csv", index=False)

NUM_FAKE_LOG = 1000
SLATE_SIZE = 15
NEGATIVE_ITEM_SIZE = 10

for name in ["offline", "online"]:
    dict_log = {
        "click_in_slate": [True] * int(NUM_FAKE_LOG * 0.5) + [False] * int(NUM_FAKE_LOG * 0.5),
        "hist_seq": np.random.randint(low=-1, high=NUM_FAKE_ITEMS, size=(NUM_FAKE_LOG, HISTORY_SIZE)).tolist(),
        "item_id": np.random.randint(low=0, high=NUM_FAKE_ITEMS, size=NUM_FAKE_LOG).tolist(),
        "slate": np.random.randint(low=-1, high=NUM_FAKE_ITEMS, size=(NUM_FAKE_LOG, SLATE_SIZE)).tolist(),
        "timestamp": [datetime.datetime.now()] * NUM_FAKE_LOG,
        "user_id": np.random.randint(low=-1, high=NUM_FAKE_USERS, size=NUM_FAKE_LOG).tolist(),
        "negative_items": np.random.randint(low=-1, high=NUM_FAKE_ITEMS,
                                            size=(NUM_FAKE_LOG, NEGATIVE_ITEM_SIZE)).tolist(),
    }

    df_log = pd.DataFrame(dict_log)
    print(df_log)
    df_log.to_csv(f"{name}_log_data.csv", index=False)
