from turtle import color
import matplotlib.pyplot as plt

def plot_line_chart(data_dict, x_ticks, x_label, y_label, title, x_labels=None):
    """
    General line chart plotting function
    :param data_dict: Dictionary with series names as keys and data lists as values
    :param x_ticks: X-axis tick positions (indices)
    :param x_labels: X-axis tick labels (optional)
    :param x_label: X-axis title
    :param y_label: Y-axis title
    :param title: Chart title
    """
    plt.figure(figsize=(18, 12))
    for series_name, values in data_dict.items():
        plt.plot(x_ticks, values, marker='o', label=series_name, linewidth=5, markersize=15)
        # Add data point value labels
        for i, value in enumerate(values):
            if i==1:
                plt.text(x_ticks[i], value + 2, f'{value}', fontsize=22, ha='center', va='top', color='red', fontweight='bold')
            else:
                plt.text(x_ticks[i], value + 2, f'{value}', fontsize=22, ha='center', va='top', fontweight='bold')
    if x_labels:
        plt.xticks(x_ticks, x_labels, fontsize=24)  # Set x-axis positions and labels
    else:
        plt.xticks(x_ticks, fontsize=24)            # Set x-axis ticks
    plt.xlabel(x_label, fontsize=30)          # Set x-axis label
    plt.ylabel(y_label, fontsize=30)          # Set y-axis label
    plt.ylim(15, 70)             # Set y-axis value range
    plt.yticks(fontsize=24)      # Set y-axis tick font size
    plt.legend(fontsize=24)      # Show legend
    # Add horizontal dashed reference lines
    y_ticks = plt.yticks()[0]
    for y in y_ticks:
        plt.axhline(y=y, color='gray', linestyle='--', alpha=0.5)
    # Add vertical dashed reference lines
    for x in x_ticks:
        plt.axvline(x=x, color='gray', linestyle='--', alpha=0.5)
    #plt.title(title, fontsize=16)             # Set chart title
    plt.savefig("./plots/line_chart.png", dpi=300, bbox_inches="tight", pad_inches=0.1)
    # Set font to avoid Type 3 fonts
    plt.rcParams['pdf.fonttype'] = 42
    plt.rcParams['font.family'] = 'DejaVu Sans'
    plt.savefig("./plots/rank.pdf", bbox_inches="tight", pad_inches=0.1)
    #plt.show()                   # Display graph
    


def main():
    accuracy_data = {
        'Attraction': [36.5,38.9,31.6,34.2],
        'Hotel': [16.0,20.4,19.7,19.2],
        'Restaurant': [22.1,31.0,26.3,20.9],
        'Train': [39.9,44.9,40.8,40.5],
        'Taxi': [68.2,68.6,68.1,67.0]
    }
    accuracy_x_ticks = [4, 8, 16, 32]
    x_positions = range(len(accuracy_x_ticks))  # Use index as position to achieve equal interval arrangement
    accuracy_x_label = 'Rank'
    accuracy_y_label = 'Joint Goal Accuracy (%)'
    accuracy_title = 'Joint Goal Accuracy by Rank'
    plot_line_chart(accuracy_data, x_positions, accuracy_x_label, accuracy_y_label, accuracy_title, x_labels=accuracy_x_ticks)


if __name__ == "__main__":
    main()