# 🌲 HiCoLoRA 🌳
Official PyTorch implementation for **"HiCoLoRa: Addressing Context-Prompt Misalignment via Hierarchical Collaborative LoRA for Zero-Shot DST"**. This repository contains the complete end-to-end code to reproduce our results, including the online generation of all results described in our work, this project will be updated more user-friendly persistently.

![HiCoLoRA Architecture](flowchart.png)

## 📋 Table of Contents
### ✨ Features
### ⚙️ Installation & Setup
### 🚀 End-to-End Workflow
### 📂 Project Structure
### 📄 Paper Reference

## ✨ Features
### 💡 Hierarchical collaborative adaptation
### 🌐 Multi-level alignment (context, intent, slot)
### 🔋 Zero-shot DST via prompt-based learning
### 🔧 Modular T5-LoRA integration

## ⚙️ Installation & Setup

**Python Version Requirement:** Python 3.10 or higher is required for this project.

```shell
# Create virtual environment
python -m venv hicolora_env
source hicolora_env/bin/activate

# Install dependencies
pip install -r requirements.txt

# Verify installation
python -c "import torch; print(f'PyTorch version: {torch.__version__}')"

pip install -r requirements.txt
```

## 🚀 End-to-End Workflow

### 📦 Dataset Preparation
```shell
# Process MultiWOZ 2.0
python create_mwoz.py

# For MultiWOZ 2.1
python create_mwoz_2_1.py
```
### 🚀 Training
```shell
# SGD
python train.py --except_domain Banks_1 --zero_initialization lora --fix_label --dataset sgd

# MultiWZ
python train.py --except_domain taxi --zero_initialization lora --fix_label
```

### 📊 Evaluation
```shell
python train.py --except_domain taxi --zero_initialization lora --fix_label --test --ckpt_best save/ckpt_best.pt
```

## 📂 Project Structure
```
HiCoLoRA/
├── PromptLoRA.py		# Core LoRA implementation
├── modeling_t5.py		# Modified T5 architecture
├── utils/
│   ├── analysis.py		# Result interpretation & visualization
│   ├── domain_slot_clustering.py	# Domain-slot relationship analysis
│   ├── fix_label.py		# Annotation correction toolkit
│   ├── generate_slot_desp.py	# Automatic slot description generation
│   ├── inference.py		# Pipeline deployment interface
│   └── layers.py		# Custom neural network components
└── evaluate.py 		# Evaluation script
```

## 🤝 Contributing
We welcome contributions to enhance this project. If you're interested in contributing, please follow these steps:

🍴 Fork the repository

🌿 Create a new branch for your feature or bug fix 
```shell
git checkout -b feature/AmazingFeature
```

💬 Commit your changes with clear messages
```shell
git commit -m 'Add some AmazingFeature'
```

📤 Push to your forked repository
```shell
git push origin feature/AmazingFeature
```

📥 Open a Pull Request detailing your changes and motivation
