# Copyright 2023 PKU-Alignment Team. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# ==============================================================================
"""RL algorithms for RLHF."""

from safe_rlhf.algorithms.dpo import DPOTrainer
from safe_rlhf.algorithms.safedpo import SafeDPOTrainer
from safe_rlhf.algorithms.ppo import PPOTrainer
from safe_rlhf.algorithms.ppo_lag import PPOLagTrainer
from safe_rlhf.algorithms.ppo_reward_shaping import PPORewardShapingTrainer


__all__ = ['DPOTrainer', 'SafeDPOTrainer', 'PPOTrainer', 'PPOLagTrainer', 'PPORewardShapingTrainer']
