import argparse




def get_config():
    parser = argparse.ArgumentParser(
        description='ddpg', formatter_class=argparse.RawDescriptionHelpFormatter)


    parser.add_argument("--eps_step", type=int, default=500000)
    parser.add_argument("--eps_end", type=float, default=0.02)
    parser.add_argument("--eps_start", type=float, default=1.0)
    # argument for MPE
    parser.add_argument("--collision_penal", type=float, default=0)
    parser.add_argument("--vision", type=float, default=1)
    parser.add_argument("--num_landmarks", type=int, default=None)
    parser.add_argument('--num_agents', type=int,
                        default=10, help="number of players")

    parser.add_argument('--env_type', type=str, default='mujoco', help="Which type of env to run on")
    parser.add_argument('--scenario', type=str, default='Hopper-v2', help="Which mujoco task to run on")
    parser.add_argument('--agent_conf', type=str, default='3x1')
    parser.add_argument('--obsk', type=int, default=2)
    parser.add_argument('--gamma', type=float, default=0.99)
    # capacity = 1000000
    parser.add_argument('--capacity', type=float, default=1000000)
    # batch_size = 100
    parser.add_argument('--batch_size', type=int, default=100)
    # max_steps = 1000000
    parser.add_argument('--max_steps', type=int, default=1000000)
    # max_ep_len = 1000
    parser.add_argument('--max_ep_len', type=int, default=1000)
    # method = 'maddpg'
    parser.add_argument('--method', type=str, default='iddpg')
    parser.add_argument('--ex_name', type=str, default='baseline')
    parser.add_argument('--warm_up_steps', type=int, default=10000)
    parser.add_argument('--test_interval', type=int, default=10000)
    parser.add_argument('--update_interval', type=int, default=1000)
    parser.add_argument('--sample_interval', type=int, default=1000)
    parser.add_argument('--mini_batch_num', type=int, default=50)
    parser.add_argument('--seed', type=int, default=1)
    parser.add_argument('--lr', type=float, default=0.0005)
    parser.add_argument('--critic_lr', type=float, default=0.0005)
    parser.add_argument('--hql_alpha', type=float, default=0.95)

    parser.add_argument('--new_actor', type=bool, default=False)
    parser.add_argument('--trainable_std', type=bool, default=False)
    # capacity = 1000000

    parser.add_argument("--cuda", action='store_false', default=True,
                        help="by default True, will use GPU to train; or else will use CPU;")
    parser.add_argument("--auto_draw", action='store_false', default=True)
    parser.add_argument("--save_loss", action='store_true', default=False)

    all_args = parser.parse_args()


    return all_args
