# Neural Regenerative Stochastic Differential Equation: Dropout Scheme for Neural Differential Equations
This repository contains the PyTorch implementation for the paper <U>Neural Regenerative Stochastic Differential Equation: Dropout Scheme for Neural Differential Equations<U>

---

## Requirements
We used:
+ Ubuntu 20.04.6 LTS
+ conda 23.7.4
+ cuda 12.1
+ Python 3.10.13
+ PyTorch 2.1.0
+ torchvision 0.16.0
+ torchaudio 2.1.0
+ torchdiffeq 0.2.3
+ torchsde 0.2.6
+ torchcde 0.2.5
+ controldiffeq 0.0.1
+ scikit-learn 1.3.2
+ sktime 0.24.1


## Installation
```bash
conda create -n nrsde python=3.10
conda activate nrsde
conda install pytorch==2.1.0 torchvision==0.16.0 torchaudio==2.1.0 pytorch-cuda=12.1 -c pytorch -c nvidia
pip install torchdiffeq==0.2.3 torchsde==0.2.6 torchcde==0.2.5 scikit-learn==1.3.2 sktime==0.24.1
```


## Task
We have conducted two major types of experiments: time series data classification and image data classification.

The code for time series data classification experiments is located in the source_time folder, while that for image data classification experiments is located in the source_image folder.

Furthermore, within the time series domain, we conducted experiments for two tasks. The first task involves simple time series datasets (SmoothSubspace, ArticularyWordRecognition, ERing, and RacketSports), while the second task involves more complex time series datasets (Speech Commands and PhysioNet Sepsis).


## Example
In our paper, we provided a brief example of Sensitivity Analysis.

Sensitivity Analysis involved experimenting with the proposed dropout (NRSDE) effect of Neural CDE in the Speech Commands dataset.

To assess the performance of our dropout, you can execute the speech_commands-cde-renewal.py file located in /NRSDE/source_time/task2/NCDE:

```bash
python3 NRSDE/source_time/task2/NCDE/speech_commands-cde-renewal.py
```


## License
We have reconstructed the code based on open-source materials. The sources used are as follows:

[Stable-Neural-SDEs](https://github.com/yongkyung-oh/Stable-Neural-SDEs)

[NeuralCDE](https://github.com/patrick-kidger/NeuralCDE)

[ANCDE](https://github.com/sheoyon-jhin/ANCDE)

[torchsde](https://github.com/google-research/torchsde)

[torchdiffeq](https://github.com/rtqichen/torchdiffeq)