This is the repo to manage all the experiments for our paper.

Our system is uses Ubuntu 20.02 OS with two TITAN RTX GPUs with an Intel i7 Processor. We use Python 3.10.0 and CUDA 11.4. We also use a SLURM cluster with various GPUS including some NVIDIA A100.

1.) To install the package, run the following commands:

`cd stnls_paper`

`python -m pip install --upgrade pip`

`python -m pip install -r reqs/reqs_cu113.txt`

`python -m pip install -r reqs/reqs_base.txt`

`python -m pip install -r reqs/reqs_local.txt`

`python -m pip install -e ../NATTEN`

`python -m pip install -e ../stnls`

2.) Installing the SWIG-wrapped Video Non-Local Bayes for their implementation of TV-L1 optical flow:

`cd ../svnlb/`

`./install.sh`

--- Video Denoising Results --

To reproduce the denoising results, first `cd stnls_paper` then run `python dev/setup_config.py`. Now you can test using `python ./scripts/trte_nlnet/test.py`. Weights will be shared upon request due to the 100 MB file size limit.

--- Networks --

Each network is contained within its pacakge name: RVRT is in rvrt, COLA-Net is in colanet, N3Net is in n3net, and STAN is in nlnet

-- Data Hub, Cache IO, Dev Basics ---

To standardize dataset access, read/write experimental results, and share some common functions, we use homemade packages named data_hub, cache_io, and dev_basics. Simply installing the above libraries will ensure our code works properly. To re-run the results, the DAVIS and Set8 datasets must be installed (see Datasets).

-- Datasets ---

Please install the Set8 and DAVIS datasets into your system. The "data_hub" package requires you specify the paths in the "path.py" files under the "data_hub/lib/data_hub/sets/davis" and "data_hub/lib/data_hub/sets/set8" directory. You can also see "data_hub/scripts/generate_flows.py" to see an example of how we precompute our optical flows.

--- STNLS ---

Our primary code is contained within the STNLS module. The CUDA code for the STNLS module is within the "lib/csrc/search" directory. The additional cuda kernels are in the "tile", "tile_k" and "reducers" directory.

--- Benchmarking Note ---

When benchmarking our methods, we ensure nothing else on our computer is running. While we appreciate many different factors contribute to the final wall-clock time and memory consumption reported in our paper, we claim the order of magnitude repored in the paper is properly controlled.

--- Misc ---

Each visual element in the paper has a corresponding script. See "docs/visual_elements.txt" for a mapping.

Happy Hacking!
