
# -- rgb videos: (noisy_vid,clean_vid) pairs --
# from . import toy64
# from . import toy
# from . import iphone
from . import set8
# from . import sid
# from . import sidd
from . import davis
# from . import gopro
# from . import iphone_s2023
# from . import iphone_sum2023

# -- video + segmentation --
# from . import cityscapes
# from . import youtube_voc

# -- real: (noisy_1,...,noisy_N,clean_frame) sets --
# from . import submillilux
# from . import sird

# -- single: (noisy_frame,clean_frame) sets --
# from . import bsd68
# from . import div2k
# from . import urban100
# from . import set12
# from . import vimeo90k

# -- segmentation --
# from . import coco

# -- misc --
from data_hub.common import optional

def load(cfg):
    dname = optional(cfg,"dname","set8")
    set_loaders = {"set8":set8,
                   "davis":davis,
                   "davis_cropped":davis.davis_cropped,}
    dnames = list(set_loaders.keys())
    if not(dname in dnames):
        print("Options: ",dnames)
        raise ValueError(f"Uknown dname [{dname}].")
    data,loaders = set_loaders[dname].load(cfg)
    return data,loaders
