import cache_io

def setup_stan():
    exps,uuids = cache_io.train_stages.run("exps/trte_nlnet/train.cfg",
                                           ".cache_io_exps/trte_nlnet/train/",
                                           update=True)
    uuids = ["stan_train"]
    cache_io.run_exps(exps,None,uuids=uuids,preset_uuids=True,
                      name=".cache_io/trte_nlnet/train",
                      version="v1",skip_loop=True,
                      clear=True,enable_dispatch="slurm")

def setup_rvrt():
    exps,uuids = cache_io.train_stages.run("exps/trte_rvrt/train.cfg",
                                           ".cache_io_exps/trte_rvrt/train/",
                                           update=True)
    uuids_new = []
    for exp in exps:
        if exp.nepochs == 1000:
            uuids_new.append("rvrt_repro")
        elif exp.offset_type == "default":
            uuids_new.append("rvrt_default")
        else:
            uuids_new.append("rvrt_search")
    cache_io.run_exps(exps,None,uuids=uuids_new,preset_uuids=True,
                      name=".cache_io/trte_rvrt/train",
                      version="v1",skip_loop=True,
                      clear=True,enable_dispatch="slurm")

def main():
    setup_stan()
    setup_rvrt()
    print("All done.")


if __name__ == "__main__":
    main()
