import svnlb
import numpy as np

# -- check threads --
svnlb.check_omp_num_threads()

# -- get data --
clean = 255.*np.random.rand(5,3,64,64)
# (nframes,channels,height,width)

# -- add noise --
std = 20.
noisy = np.random.normal(clean,scale=std)

# -- TV-L1 Optical Flow --
fflow,bflow = svnlb.swig.runPyFlow(noisy,std)

# -- Video Non-Local Bayes --
result = svnlb.swig.runPyVnlb(noisy,std,{'fflow':fflow,'bflow':bflow})
denoised = result['denoised']

# -- compute denoising quality --
psnrs = svnlb.utils.compute_psnrs(clean,denoised)
print("PSNRs:")
print(psnrs)
