# Distributed Quantile Estimation and Confidence Interval Project

This code project implements the method proposed in our paper, which introduces a novel algorithm for constructing time-uniform, asymptotic confidence sequences for quantiles under the constraint of local differential privacy (LDP). The code incorporates parallel simulation using Ray. Since our method is robust to different underlying distributions, the implementation in our code supports a variety of distribution types, including normal, uniform, cauchy, and laplace distributions.

## Directory Structure

- `DPQuantile.py`: Implements basic differentially private quantile estimation algorithms.
- `MultiChainDPQuantile.py`: Implements multi-chain distributed differentially private quantile estimation.
- `GADPQuantile.py`: Our proposed method, which implements Gaussian approximation for differentially private quantile estimation in a multi-chain approach. A Utility function computing radius is also included.
- `baseline.py`: Baseline methods and its confidence interval simulations, which is order-statistics-based and non-private.
- `get_error_length.py`: Analysis and saving of error and confidence interval length.
- `get_sequence_single.py`: Analysis and saving of single-sample confidence interval sequences.
- `get_var.py`: Analysis and saving of variance.
- `remote_GA_kfix.py`, `remote_GA_kchange.py`: Ray-based distributed parallel simulation scripts for fixed kappa and increasing kappa.
- `util.py`: Utility functions (data generation, theoretical variance, etc.).
- `requirements.txt`: Dependency list.
- `plot_error_length.ipynb`: Jupyter Notebook for error, interval length and variance visualization.

## Main Features

- Supports constructing time-uniform, asymptotic confidence sequences for quantiles for multiple distributions under Differential Privacy condition.
- Multi-chain parallel estimation and dynamic chain number adjustment.
- Distributed simulation and result collection based on Ray.
- Statistical analysis and visualization of error, interval length, etc.

## Quick Start

1. Install dependencies:
   ```bash
   pip install -r requirements.txt
2. Get the simulation results:
   ```bash
   python ./remote_GA_kfix.py
   python ./remote_GA_kchange.py
   python ./baseline.py
3. Analysis the simulation results and save error, length and variance:
   ```bash
   python ./get_error_length.py
   python ./get_sequence_single.py
   python ./get_var.py
4. Visualize the simulation results:
   Open the jupyter notebook and run the code fot plotting.
