import java.util.*;
import java.io.*;

class DPAPParameters extends Parameters {
    
    /*****************************************************************/
    /*                     Instance Variables                        */
    /*****************************************************************/

    // All instance variables are public.  This is a thin class.
    public double dampingFactor_;
    public double mutexDampingFactor_;
    public boolean doFineTuning_;

    /*****************************************************************/
    /*                            Methods                            */
    /*****************************************************************/

    /**
     * Simple default constructor.
     */
    public DPAPParameters() {
	parameterFile_ = "default";
	SetToDefault();
    }

    /**
     * Construct from file.
     */
    public DPAPParameters(String parameterFile) {
	parameterFile_ = parameterFile;
	SetToDefault();
	LoadFromFile(parameterFile);
    }

    /**
     * Choose a default set of parameters.
     */
    public void SetToDefault() {
	dampingFactor_ = .7;
	mutexDampingFactor_ = 0;
	doFineTuning_ = true;
    }

    /**
     * Given a filename, load parameters.  The file should be a text file
     * of the following form:
     * <parameter1_name> <parameter1_value>
     * ...
     * <parameterN_name> <parameterN_value>
     */
    public void LoadFromFile(String filename) {
	try {
	    BufferedReader input = 
		new BufferedReader(new FileReader(filename));

	    // There's just one line to read
	    String line ;
	    while ( (line = input.readLine()) != null ) {
		String[] entries = line.trim().split("\\s+");		
		
		// Allow blank lines
		if (entries.length == 0) continue;
		
		// Otherwise, there must be 2 entries per line
		assert(entries.length == 2);

		if (entries[0].equals("dampingFactor")) {
		    dampingFactor_ = Double.parseDouble(entries[1]);

		} else if (entries[0].equals("mutexDampingFactor")) {
		    mutexDampingFactor_ = Double.parseDouble(entries[1]);

		} else if (entries[0].equals("doFineTuning")) {
		    if (entries[1].equals("true")) {
			doFineTuning_ = true;
		    } else if (entries[1].equals("false")) {
			doFineTuning_ = false;
		    } else {
			assert false : "Unexpected setting of doFineTuning: " + entries[1]; 
		    }
		    
		} else {
		    System.err.println("Warning: unknown parameter " +
				       entries[0] + ", value = " + entries[1]);
		}
	    }
	}
	catch (Exception ex){
	    ex.printStackTrace();
	    System.exit(1);
	}	
    }

    /**
     * Filename portion for algorithm specific parameters
     */
    public String FileName() {
	String filename = "DPAP_";
	filename += "df" + dampingFactor_ + "_";
	filename += "mdf" + mutexDampingFactor_ + "_";
	filename += "ft" + doFineTuning_ + "_";
	return filename;
    }

    /*****************************************************************/
    /*                              Main                             */
    /*****************************************************************/    
    
    public static void main(String args[]) {
	DPAPParameters params = new DPAPParameters(args[0]);
	
	System.out.println("Derived filename: " + params.FileName());
    }

}
