package lk.apiit.friends.service.rules;

import java.io.Serializable;

import lk.apiit.friends.model.User;

/**
 * Interface definition for a Membership Rule.
 * 
 * @author Yohan Liyanage
 * @version 14-Sep-2008
 * @since 14-Sep-2008
 */
public interface MembershipRule extends Serializable {
	
	/**
	 * Checks a given user instance to see
	 * if the user satisfies this rule.
	 * 
	 * @param user user
	 * @return true if success
	 */
	public boolean check(User user);
}
