package client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.jms.core.JmsTemplate;

public class ClientMain {

	public static void main(String[] args) throws IOException {
		String[] configLocations = new String[] { 
				"classpath:/spring-common.xml",
				"classpath:/spring-jms.xml" };
		ApplicationContext ctx = new ClassPathXmlApplicationContext(configLocations);
		
		JmsTemplate template = (JmsTemplate) ctx.getBean("jmsTemplate");
		
		List<MessageProducerRunner> runners = new ArrayList<MessageProducerRunner>(100);
		for (int i = 0; i < 1000; i++) {
			MessageProducerRunner runner = new MessageProducerRunner(template);
			runners.add(runner);
		}
		for (MessageProducerRunner runner : runners) {
			new Thread(runner).start();
		}
	}
}
